package com.leafready.ads.models;

import android.net.Uri;
import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

public class MAdItem {

	private String id;
	private String title;
	private String bannerUrl;
	private byte[] bannerData;
//	private String postBackUrl;
//	private String packageName;
	private String externalUrl;
	private int coin;

	public MAdItem() {}
	
	public MAdItem(String jsonStr) throws JSONException {
		JSONObject jsonObj = new JSONObject(jsonStr);
		init(jsonObj);
	}
	
	public MAdItem (JSONObject jsonObj) throws JSONException {
		init(jsonObj);
	}
	
	private void init(JSONObject jsonObj) throws JSONException {
		if (jsonObj.has("hide_id")) {
			id = jsonObj.getString("hide_id");
		}
		if (jsonObj.has("title")) {
			title = jsonObj.getString("title");
		}
		if (jsonObj.has("banner_url")) {
			bannerUrl = jsonObj.getString("banner_url");
			bannerUrl.replace("https","http");
		}
//		if (jsonObj.has("postback_url")) {
//			postBackUrl = jsonObj.getString("postback_url");
//		}
		if (jsonObj.has("open_url")) {
			externalUrl = jsonObj.getString("open_url");
		}
//		if (jsonObj.has("package_name")) {
//			packageName = jsonObj.getString("package_name");
//		}
		if (jsonObj.has("coin")){
			coin = jsonObj.getInt("coin");
		}
	}
	
	public String getTitle() {
		return title+"";
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getId() {
		return id+"";
	}

	public void setId(String id) {
		this.id = id;
	}

	public boolean hasBannerUrl() {
		return !TextUtils.isEmpty(bannerUrl);
	}

	public String getBannerUrl() {
		return bannerUrl+"";
	}

	public void setBannerUrl(String bannerUrl) {
		this.bannerUrl = bannerUrl;
	}

//	public String getPostBackUrl() {
//		return postBackUrl;
//	}
//
//	public void setPostBackUrl(String postBackUrl) {
//		this.postBackUrl = postBackUrl;
//	}
//
//	public String getPackageName() {
//		return packageName;
//	}
//
//	public void setPackageName(String packageName) {
//		this.packageName = packageName;
//	}

	public String getExternalUrl() {
		return externalUrl+"";
	}
	
	public Uri getExternalUri() {
		return Uri.parse(externalUrl);
	}

	public void setExternalUrl(String externalUrl) {
		this.externalUrl = externalUrl;
	}

	public byte[] getBannerData() {
		return bannerData;
	}

	public void setBannerData(byte[] bannerData) {
		this.bannerData = bannerData;
	}

	public int getCoin() {
		return coin;
	}
	
	public void setCoin(int coin) {
		this.coin = coin;
	}

}
