package com.leafready.ads.models;

import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class MAd {
	
	private int status;
	private int autoSlideTime = 0;
	private String showAdsUrl;
	private String error;
	private String pubKeyAdmob;
	private int popupType;
	
	private ArrayList<MAdItem> adItems;

	public MAd() {}
	
	public MAd(String jsonStr) throws JSONException {
		JSONObject jsonObj = new JSONObject(jsonStr);
		init(jsonObj);
	}

	public MAd(JSONObject jsonObj) throws JSONException {
		init(jsonObj);
	}

	private void init(JSONObject jsonObj) throws JSONException {
		if (jsonObj.has("status")) {
			status = jsonObj.getInt("status");
		}
		if (jsonObj.has("error")) {
			error = jsonObj.getString("error");
		}
		if (jsonObj.has("popup_type")) {
			popupType = jsonObj.getInt("popup_type");
		}
		if (jsonObj.has("save_imp_url")) {
			showAdsUrl = jsonObj.getString("save_imp_url");
		}
		if (jsonObj.has("auto_slide")) {//auto_slide
			autoSlideTime = jsonObj.getInt("auto_slide") * 1000;//auto_slide
		}
		if(jsonObj.has("admob_adunit")){
			pubKeyAdmob = jsonObj.getString("admob_adunit");
		}

		adItems = new ArrayList<MAdItem>();
		if (jsonObj.has("banners")) {
			try {
				JSONArray jsonArray = jsonObj.getJSONArray("banners");

				for (int i = 0; i < jsonArray.length(); i++) {
					try {
						JSONObject jsonObj1 = jsonArray.getJSONObject(i);
						MAdItem adItem = new MAdItem(jsonObj1);
						adItems.add(adItem);
					} catch (JSONException e) {
						// Just ignore error MAdItem 
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	}

	public String getPubKeyAdmob() {
		return pubKeyAdmob+"";
	}

	public void setPubKeyAdmob(String pubKeyAdmob) {
		this.pubKeyAdmob = pubKeyAdmob;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public int getPopupType() {
		return popupType;
	}

	public void setPopupType(int popupType) {
		this.popupType = popupType;
	}

	public boolean isAutoSlide() {
		if (autoSlideTime <= 0) {
			return false;
		} else {
			return true;
		}
	}

	public int getAutoSlideTime() {
		return autoSlideTime;
	}

	public void setAutoSlideTime(int autoSlideTime) {
		this.autoSlideTime = autoSlideTime;
	}

	public String getShowAdsUrl() {
		return showAdsUrl+"";
	}

	public void setShowAdsUrl(String showAdsUrl) {
		this.showAdsUrl = showAdsUrl;
	}
	
	public boolean hasError() {
		return !TextUtils.isEmpty(error);
	}

	public String getError() {
		return error+"";
	}

	public void setError(String error) {
		this.error = error;
	}

	public ArrayList<MAdItem> getAdItems() {
		return adItems;
	}

	public void setAdItems(ArrayList<MAdItem> adItems) {
		this.adItems = adItems;
	}

}
