package com.leafready.ads.dialogs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.ViewGroup.LayoutParams;
import android.widget.ImageButton;

import com.leafready.ads.R;
import com.leafready.ads.adapters.Type13PagerAdapter;
import com.leafready.ads.autoscrollviewpager.AutoScrollViewPager;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.TouchOutSideDialogContentDetector;
import com.leafready.ads.utils.UpdateViewUtils;
import com.leafready.ads.utils.UpdateViewUtils.ViewTreeListener;
import com.leafready.ads.views.MobileIndicator;

import java.util.ArrayList;

public class Type_1_3_Dialog extends BaseDialog {
	
	private final String TAG = Type_1_3_Dialog.class.getSimpleName();
	protected View rootView;
	protected ImageButton btnClose;
	protected AutoScrollViewPager viewPager;
	private boolean isEncrypted;
	private ArrayList<MAdItem> adItems;
	private MobileIndicator layoutIndicators;
	private Type13PagerAdapter pagerAdapter;
	private GestureDetector gestureDetector;

	public Type_1_3_Dialog(Activity activity, MAd model) {
		super(activity, model);
		gestureDetector = new GestureDetector(activity, new TouchOutSideDialogContentDetector(this));
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		try {
			setContentView(R.layout.dialog_popup_1_3_);
			isEncrypted = true;
			rootView = findViewById(R.id.layout_root);
			btnClose = (ImageButton) findViewById(R.id.btn_close);
			adItems = model.getAdItems();
			viewPager = (AutoScrollViewPager) findViewById(R.id.view_pager);
			pagerAdapter = new Type13PagerAdapter(adItems, isEncrypted,this);
			viewPager.setAdapter(pagerAdapter);
			layoutIndicators = (MobileIndicator) findViewById(R.id.layout_indicator);
			layoutIndicators.setViewPager(viewPager);
			rootView.setOnTouchListener(new OnTouchListener() {

				@SuppressLint("ClickableViewAccessibility")
				@Override
				public boolean onTouch(View view, MotionEvent event) {
					try {
						gestureDetector.onTouchEvent(event);
						return true;
					}catch (Exception e){
						e.printStackTrace();
						return false;
					}
				}
			});
			btnClose.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View view) {
					try {
						dismiss();
					}catch (Exception e){
						e.printStackTrace();
					}
				}
			});
			if (model.getAutoSlideTime() > 0) {
				viewPager.setInterval(model.getAutoSlideTime());
				viewPager.startAutoScroll();
			}

			UpdateViewUtils.updatWhenViewTreeLoaded(activity, viewPager, new ViewTreeListener() {

				@Override
				public void done() {
					try {
						MAdItem adItem = adItems.get(0);

						if (adItem == null) {
							return;
						}

						byte[] bytes = adItem.getBannerData();
						float[] optimalSize = GifUtils.loadBytesToGifImage(activity, bytes,
								null, true);
						int oRientation = DeviceUtils.getScreenOrientation(activity);

						LayoutParams lp = viewPager.getLayoutParams();
						if (oRientation == 1) {
							lp.width = (int) (optimalSize[0] + 24 * DeviceUtils
									.getDensity(activity));
							lp.height = (int) (optimalSize[1] + 84 * DeviceUtils
									.getDensity(activity));

						} else {
							lp.width = (int) (optimalSize[0] + 34 * DeviceUtils
									.getDensity(activity));
							lp.height = (int) (optimalSize[1] + 34 * DeviceUtils
									.getDensity(activity));
						}

						if (lp.width <= 0) {
							return;
						}
						viewPager.setLayoutParams(lp);
					}catch (Exception e){
						e.printStackTrace();
					}
				}
			});
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	@Override
	public void show() {
		super.show();
	}

}
