package com.leafready.ads;

import android.app.Activity;
import android.graphics.Bitmap;

import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.GifImageView;


abstract class AbstractAd {
	
	protected AdListener adListener;
	protected Status adStatus = Status.INIT;
	
	public static final int ERROR_CONNECTION = 100;
	public static final int ERROR_CORRUPTED = 101;
	public static final int ERROR_EMPTY = 102;
	public static final int ERROR_SERVER = 103;
	
	public static final long TIMEOUT = 30 * 1000;
	
	public enum Status {
		INIT, LOADING, PARTIAL_LOADED, LOADED, ERROR
	}

	public void setAdListener(AdListener adListener) {
		this.adListener = adListener;
	};

	public abstract void loadAd();

	public boolean isLoading() {
		return adStatus == Status.LOADING;
	}
	
	public boolean isPartialLoaded() {
		return adStatus == Status.PARTIAL_LOADED;
	}

	public boolean isLoaded() {
		return adStatus == Status.LOADED;
	};
	
	protected boolean isInInitState() {
		return adStatus == Status.INIT;
	}
	
	public abstract void show();
	
	protected abstract boolean isShowing();
	
	protected abstract void close();
	
	void loadBytesToGifImageView(Activity a, byte[] bytes, GifImageView imageView) {
		if (!GifUtils.isGif(bytes)) {
			Bitmap bitmap = Utils.getBitmapfromBytes(bytes);
//			float[] resizeImage = Utils.getProperSizeForPopupImage(a, bitmap);
			float[] resizeImage = Utils.getProperSizeForIntertitialImage(a, bitmap);
			Bitmap newBitmap = Bitmap.createScaledBitmap(bitmap,
					(int) resizeImage[0], (int) resizeImage[1], true);
			imageView.setImageBitmap(newBitmap);
		} else {
			imageView.setBytes(bytes);
			imageView.startAnimation();
		}
	}
	
}
