/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.views;

import android.app.Activity;
import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;

public class StickyHorizontalScrollView
extends HorizontalScrollView {
    Context context;
    int prevIndex = 0;
    BaseAdapter adapter;
    private final DataSetObserver observer = new DataSetObserver(){

        public void onChanged() {
            StickyHorizontalScrollView.this.refreshViewsFromAdapter();
        }

        public void onInvalidated() {
            StickyHorizontalScrollView.this.removeAllViews();
        }
    };
    int sizeElement;

    public StickyHorizontalScrollView(Context context) {
        super(context);
        this.context = context;
        this.setSmoothScrollingEnabled(true);
        this.setHorizontalScrollBarEnabled(false);
    }

    public StickyHorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setSmoothScrollingEnabled(true);
        this.setHorizontalScrollBarEnabled(false);
    }

    public StickyHorizontalScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.context = context;
        this.setSmoothScrollingEnabled(true);
        this.setHorizontalScrollBarEnabled(false);
    }

    public void setAdapter(Context context, BaseAdapter mAdapter) {
        try {
            if (this.adapter != null) {
                this.adapter.unregisterDataSetObserver(this.observer);
            }
            this.adapter = mAdapter;
            if (this.adapter != null) {
                this.adapter.registerDataSetObserver(this.observer);
            }
            this.initViewsFromAdapter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initViewsFromAdapter() {
        try {
            ViewGroup parent = (ViewGroup)this.getChildAt(0);
            parent.removeAllViews();
            for (int i = 0; i < this.adapter.getCount(); ++i) {
                parent.addView(this.adapter.getView(i, null, parent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void refreshViewsFromAdapter() {
        try {
            int i;
            int childCount = this.getChildCount();
            int adapterSize = this.adapter.getCount();
            int reuseCount = Math.min(childCount, adapterSize);
            ViewGroup parent = (ViewGroup)this.getChildAt(0);
            for (i = 0; i < reuseCount; ++i) {
                this.adapter.getView(i, parent.getChildAt(i), (ViewGroup)this);
            }
            if (childCount < adapterSize) {
                for (i = childCount; i < adapterSize; ++i) {
                    parent.addView(this.adapter.getView(i, null, (ViewGroup)this), i);
                }
            } else if (childCount > adapterSize) {
                parent.removeViews(adapterSize, childCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCenter(Activity context, int index) {
        try {
            ViewGroup parent = (ViewGroup)this.getChildAt(0);
            View preView = parent.getChildAt(this.prevIndex);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
            lp.setMargins(5, 5, 5, 5);
            preView.setLayoutParams((ViewGroup.LayoutParams)lp);
            View view = parent.getChildAt(index);
            int screenWidth = context.getWindowManager().getDefaultDisplay().getWidth();
            int scrollX = view.getLeft() - screenWidth / 2 + view.getWidth() / 2;
            this.smoothScrollTo(scrollX, 0);
            this.prevIndex = index;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        try {
            super.onScrollChanged(l, t, oldl, oldt);
            Log.d((String)"abc", (String)("tham so:" + l + "," + t + "," + oldl + "," + oldt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getItemHorizontal(int width, int listSize) {
        try {
            int computeRange = this.computeHorizontalScrollRange();
            int offset = this.computeHorizontalScrollOffset();
            int sizeHorizontal = computeRange - width;
            this.sizeElement = sizeHorizontal / listSize;
            if (offset > this.sizeElement * 4) {
                return 4;
            }
            if (offset > this.sizeElement * 3) {
                return 3;
            }
            if (offset > this.sizeElement * 2) {
                return 2;
            }
            if (offset > this.sizeElement * 1) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

