/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.content.Context;
import android.content.SharedPreferences;

public final class SharedPreferenceUtils {
    private static final String PREFERENCE_NAME = "ads_Mobilegame";

    public static SharedPreferences getSharedPreferences(Context context) {
        if (context != null) {
            return context.getSharedPreferences(PREFERENCE_NAME, 0);
        }
        return null;
    }

    public static String getStringValue(Context context, String key) {
        try {
            SharedPreferences sharedPreferences = SharedPreferenceUtils.getSharedPreferences(context);
            return sharedPreferences.getString(key, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean saveStringValue(Context context, String key, String value) {
        try {
            SharedPreferences sharedPreferences = SharedPreferenceUtils.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveIntValue(Context context, String key, int value) {
        try {
            SharedPreferences sharedPreferences = SharedPreferenceUtils.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveBooleanValue(Context context, String key, boolean value) {
        try {
            SharedPreferences sharedPreferences = SharedPreferenceUtils.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putBoolean(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getIntValue(Context context, String key, int defaultValue) {
        try {
            SharedPreferences sharedPreferences = SharedPreferenceUtils.getSharedPreferences(context);
            return sharedPreferences.getInt(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean getBooleanValue(Context context, String key, boolean defaultValue) {
        try {
            SharedPreferences sharedPreferences = SharedPreferenceUtils.getSharedPreferences(context);
            return sharedPreferences.getBoolean(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

