/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.View;
import com.leafready.ads.utils.LogUtils;
import java.util.Calendar;

public class ClickEventDetector {
    private static final String TAG = "ClickEventDetector";
    private static final int MAX_CLICK_DURATION = 150;
    private static boolean isHold = false;

    public static void setOnTouchEvent(ClickListener clickListener, View ... views) {
        try {
            for (int i = 0; i < views.length; ++i) {
                ClickEventDetector.setOnTouchEvent(views[i], clickListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setOnTouchEvent(View view, final ClickListener listener) {
        if (view == null) {
            return;
        }
        view.setOnTouchListener(new View.OnTouchListener(){
            private long startClickTime;
            private long timeStartMoving;
            private long totalTimeMoving;

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View view, MotionEvent event) {
                try {
                    switch (event.getAction()) {
                        case 0: {
                            LogUtils.log(view.getContext(), ClickEventDetector.TAG, "Touch view: down");
                            isHold = false;
                            this.startClickTime = Calendar.getInstance().getTimeInMillis();
                            break;
                        }
                        case 2: {
                            LogUtils.log(view.getContext(), ClickEventDetector.TAG, "Touch view: move");
                            if (this.timeStartMoving == 0L) {
                                this.timeStartMoving = Calendar.getInstance().getTimeInMillis();
                            }
                            this.totalTimeMoving = Calendar.getInstance().getTimeInMillis() - this.timeStartMoving;
                            break;
                        }
                        case 1: {
                            this.timeStartMoving = 0L;
                            LogUtils.log(view.getContext(), ClickEventDetector.TAG, String.format("Touch view: up. startClickTime: %s - totalTimeMoving: %s", this.startClickTime, this.totalTimeMoving));
                            LogUtils.log(view.getContext(), ClickEventDetector.TAG, String.format("Touch view: up. total startClickTime: %s", this.startClickTime));
                            long clickDuration = Calendar.getInstance().getTimeInMillis() - this.startClickTime + this.totalTimeMoving;
                            LogUtils.log(view.getContext(), ClickEventDetector.TAG, String.format("Touch view: up. total clickDuration: %s", clickDuration));
                            if (clickDuration < 150L && !isHold) {
                                listener.onClick(view);
                            }
                            this.totalTimeMoving = 0L;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View arg0) {
                isHold = true;
                return false;
            }
        });
    }

    public static interface ClickListener {
        public void onClick(View var1);
    }
}

