/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.models;

import android.net.Uri;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MAdItem {
    private String id;
    private String title;
    private String bannerUrl;
    private byte[] bannerData;
    private String externalUrl;
    private int coin;

    public MAdItem() {
    }

    public MAdItem(String jsonStr) throws JSONException {
        JSONObject jsonObj = new JSONObject(jsonStr);
        this.init(jsonObj);
    }

    public MAdItem(JSONObject jsonObj) throws JSONException {
        this.init(jsonObj);
    }

    private void init(JSONObject jsonObj) throws JSONException {
        if (jsonObj.has("hide_id")) {
            this.id = jsonObj.getString("hide_id");
        }
        if (jsonObj.has("title")) {
            this.title = jsonObj.getString("title");
        }
        if (jsonObj.has("banner_url")) {
            this.bannerUrl = jsonObj.getString("banner_url");
            this.bannerUrl.replace("https", "http");
        }
        if (jsonObj.has("open_url")) {
            this.externalUrl = jsonObj.getString("open_url");
        }
        if (jsonObj.has("coin")) {
            this.coin = jsonObj.getInt("coin");
        }
    }

    public String getTitle() {
        return this.title + "";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id + "";
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public boolean hasBannerUrl() {
        return !TextUtils.isEmpty((CharSequence)this.bannerUrl);
    }

    public String getBannerUrl() {
        return this.bannerUrl + "";
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public String getExternalUrl() {
        return this.externalUrl + "";
    }

    public Uri getExternalUri() {
        return Uri.parse((String)this.externalUrl);
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public byte[] getBannerData() {
        return this.bannerData;
    }

    public void setBannerData(byte[] bannerData) {
        this.bannerData = bannerData;
    }

    public int getCoin() {
        return this.coin;
    }

    public void setCoin(int coin) {
        this.coin = coin;
    }
}

