/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.models;

import android.text.TextUtils;
import com.leafready.ads.models.MAdItem;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MAd {
    private int status;
    private int autoSlideTime = 0;
    private String showAdsUrl;
    private String error;
    private String pubKeyAdmob;
    private int popupType;
    private ArrayList<MAdItem> adItems;

    public MAd() {
    }

    public MAd(String jsonStr) throws JSONException {
        JSONObject jsonObj = new JSONObject(jsonStr);
        this.init(jsonObj);
    }

    public MAd(JSONObject jsonObj) throws JSONException {
        this.init(jsonObj);
    }

    private void init(JSONObject jsonObj) throws JSONException {
        if (jsonObj.has("status")) {
            this.status = jsonObj.getInt("status");
        }
        if (jsonObj.has("error")) {
            this.error = jsonObj.getString("error");
        }
        if (jsonObj.has("popup_type")) {
            this.popupType = jsonObj.getInt("popup_type");
        }
        if (jsonObj.has("save_imp_url")) {
            this.showAdsUrl = jsonObj.getString("save_imp_url");
        }
        if (jsonObj.has("auto_slide")) {
            this.autoSlideTime = jsonObj.getInt("auto_slide") * 1000;
        }
        if (jsonObj.has("admob_adunit")) {
            this.pubKeyAdmob = jsonObj.getString("admob_adunit");
        }
        this.adItems = new ArrayList();
        if (jsonObj.has("banners")) {
            try {
                JSONArray jsonArray = jsonObj.getJSONArray("banners");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    try {
                        JSONObject jsonObj1 = jsonArray.getJSONObject(i);
                        MAdItem adItem = new MAdItem(jsonObj1);
                        this.adItems.add(adItem);
                        continue;
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getPubKeyAdmob() {
        return this.pubKeyAdmob + "";
    }

    public void setPubKeyAdmob(String pubKeyAdmob) {
        this.pubKeyAdmob = pubKeyAdmob;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getPopupType() {
        return this.popupType;
    }

    public void setPopupType(int popupType) {
        this.popupType = popupType;
    }

    public boolean isAutoSlide() {
        return this.autoSlideTime > 0;
    }

    public int getAutoSlideTime() {
        return this.autoSlideTime;
    }

    public void setAutoSlideTime(int autoSlideTime) {
        this.autoSlideTime = autoSlideTime;
    }

    public String getShowAdsUrl() {
        return this.showAdsUrl + "";
    }

    public void setShowAdsUrl(String showAdsUrl) {
        this.showAdsUrl = showAdsUrl;
    }

    public boolean hasError() {
        return !TextUtils.isEmpty((CharSequence)this.error);
    }

    public String getError() {
        return this.error + "";
    }

    public void setError(String error) {
        this.error = error;
    }

    public ArrayList<MAdItem> getAdItems() {
        return this.adItems;
    }

    public void setAdItems(ArrayList<MAdItem> adItems) {
        this.adItems = adItems;
    }
}

