/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.dialogs;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ImageButton;
import com.leafready.ads.R;
import com.leafready.ads.adapters.Type5PagerAdapter;
import com.leafready.ads.dialogs.BaseDialog;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.ClickOutsideDetector;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.views.MobileIndicator;
import java.util.ArrayList;

public class Type5Dialog
extends BaseDialog {
    private final String TAG = Type5Dialog.class.getSimpleName();
    private ArrayList<MAdItem> adItems;
    private ImageButton btnClose;
    private ViewPager viewPager;
    public int pagerPadding;
    private boolean isEncrypted;
    private MobileIndicator layoutIndicators;
    private Type5PagerAdapter adsPagerAdapter;
    public View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Type5Dialog.this.onClickHandler(Type5Dialog.this.adsPagerAdapter.getCurrentItem(Type5Dialog.this.viewPager.getCurrentItem()));
        }
    };

    public void onClickHandler(MAdItem adItem) {
        try {
            Intent browserIntent = new Intent("android.intent.action.VIEW", adItem.getExternalUri());
            this.activity.startActivity(browserIntent);
            this.dismiss();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Type5Dialog(Activity activity, MAd model) {
        super(activity, model);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.setContentView(R.layout.dialog_popup_5);
            this.isEncrypted = true;
            this.adItems = this.model.getAdItems();
            this.viewPager = (ViewPager)this.findViewById(R.id.overlap_pager);
            this.viewPager.setClipToPadding(false);
            this.viewPager.setOffscreenPageLimit(this.adItems.size());
            this.adsPagerAdapter = new Type5PagerAdapter(this.adItems, this.isEncrypted, this);
            this.viewPager.setAdapter((PagerAdapter)this.adsPagerAdapter);
            ClickOutsideDetector.setListener((View)this.viewPager, new ClickOutsideDetector.ClickListener(){

                @Override
                public void onClick(View view) {
                    LogUtils.log((Context)Type5Dialog.this.activity, Type5Dialog.this.TAG, "click outside ad content");
                    Type5Dialog.this.dismiss();
                }
            });
            this.btnClose = (ImageButton)this.findViewById(R.id.btn_close);
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Type5Dialog.this.dismiss();
                }
            });
            this.layoutIndicators = (MobileIndicator)this.findViewById(R.id.layout_indicator);
            this.layoutIndicators.setViewPager(this.viewPager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePadding() {
        try {
            if (this.pagerPadding == 0) {
                return;
            }
            this.viewPager.setPadding(this.pagerPadding, 0, this.pagerPadding, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

