package com.leafready.ads.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;

import com.leafready.ads.utils.AdvertisingIdClient.AdInfo;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class Utils {
	static String checkInstall = "";
	public static String splitString(String str){
		try {
			if(str.length() > 15){
				String s = str.substring(0, 13);
				s = s + "...";
				return s;
			}else{
				return str;
			}
		}catch (Exception e){
			e.printStackTrace();
			return "";
		}
	}
	public static boolean isJSONObject(String jsonString) {
		try {
			if (TextUtils.isEmpty(jsonString)) {
				return false;
			} else {
				try {
					new JSONObject(jsonString);
				} catch (JSONException ex) {
					return false;
				}
			}
			return true;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
	
	public static boolean isJSONArray(String jsonString) {
		try {
			if (TextUtils.isEmpty(jsonString)) {
				return false;
			} else {
				try {
					new JSONArray(jsonString);
				} catch (JSONException ex) {
					return false;
				}
			}
			return true;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	private static String advertisingId = "";

	public static String getAdvertisingID(final Context context) {
		try {
			if (!TextUtils.isEmpty(advertisingId)){
				return advertisingId;
			}

			Thread thread = new Thread(new Runnable() {

				@Override
				public void run() {
					try {
						AdInfo adInfo = AdvertisingIdClient
								.getAdvertisingIdInfo(context);
						String adId = adInfo.getId();
						Log.i("Google Advertising id:", "GA ID :" + adId);
						advertisingId = adId;
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			});
			thread.start();
			try {
				thread.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return advertisingId+"";
	}

	public static String getVersionOS(final Context context) {
		try {
			String release = Build.VERSION.RELEASE;
			// int sdkVersion = Build.VERSION.SDK_INT;
			Log.d("version OS :","version OS :" + release);
			return "android-" + release + "";
		}catch (Exception e){
			e.printStackTrace();
			return "android-";
		}
	}

	public static String getNetworkType(final Context context) {
		try {
			ConnectivityManager conMan = (ConnectivityManager) context
					.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo netWorkInfo = conMan.getActiveNetworkInfo();
			if (netWorkInfo != null) {
				return netWorkInfo.getTypeName().toLowerCase();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return "";
	}

	public static String getLanguage(final Context context) {
		try {
			String deviceLocale = Locale.getDefault().getLanguage();
			Log.d("language device :" ,"language device :" + deviceLocale);
			return deviceLocale;
		}catch (Exception e){
			e.printStackTrace();
			return "";
		}
	}

	public static Bitmap decodeBase64(String input) {
		byte[] decodedByte = Base64.decode(input, Base64.DEFAULT);
		return BitmapFactory
				.decodeByteArray(decodedByte, 0, decodedByte.length);
	}

	public static String getSHACheckSum(String checksum) {
		try {
			MessageDigest md = MessageDigest.getInstance("SHA1");
			md.update(checksum.getBytes());
			byte byteData[] = md.digest();

			// convert the byte to hex format method 1
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < byteData.length; i++) {
				sb.append(Integer.toString((byteData[i] & 0xff) + 0x100, 16)
						.substring(1));
			}
			return sb.toString();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return null;
		}
	}

	public static String getMD5CheckSumFromByteArray(byte[] byteArray) {
		try {
			MessageDigest md5 = MessageDigest.getInstance("MD5");
			md5.update(byteArray, 0, byteArray.length);
			BigInteger bi = new BigInteger(1, md5.digest());
			return String.format("%0" + (md5.digest().length << 1) + "x", bi);
		} catch (NoSuchAlgorithmException e) {
			return null;
		} catch (NullPointerException e) {
			return null;
		}
	}
	
//	public static float[] getProperSizeForPopupImage(Activity activity,byte[] bytes){
//		float[] result = new float[2];
//		Bitmap bmp = BitmapFactory.decodeByteArray(bytes, 0, bytes.length);
//		result = getProperSizeForPopupImage(activity, bmp);
//		return result;
//	}
	
//	public static float[] getProperSizeForPopupImage(Context c, Bitmap bitmap) {
//		float[] result = new float[2];
//		float density = DeviceUtils.getDensity(c);
//		float width_screen = DeviceUtils.getScreenWidthInPixels(c);
//		float height_screen = DeviceUtils.getScreenHeightInPixels(c);
//		float ratio_screen = width_screen / height_screen;
//
//		float width_image = bitmap.getWidth();
//		float height_image = bitmap.getHeight();
//		float ratio_image = width_image / height_image;
//
//		if (ratio_image < ratio_screen) {
//			height_image = height_screen - 60 * density;
//			width_image = height_image * ratio_image;
//			result[0] = width_image;
//			result[1] = height_image;
//		} else {
//			width_image = width_screen - 60 * density;
//			height_image = width_image / ratio_image;
//			result[0] = width_image;
//			result[1] = height_image;
//		}
//
//		return result;
//	}
	public static float[] getProperSizeForIntertitialImage(Context c, Bitmap bitmap) {
		float[] result = new float[2];
		try {
			float density = DeviceUtils.getDensity(c);
			float width_screen = DeviceUtils.getScreenWidthInPixels(c);
			float height_screen = DeviceUtils.getScreenHeightInPixels(c) - 104 * density;
			float ratio_screen = width_screen / height_screen;

			float width_image = bitmap.getWidth();
			float height_image = bitmap.getHeight();
			float ratio_image = width_image / height_image;
			int orientation = DeviceUtils.getScreenOrientation(c);
			if(orientation == 1){
				Log.d("portrait", "portrait");
				if (ratio_image < ratio_screen) {
					height_image = height_screen - 60 * density;
					width_image = height_image * ratio_image;
					result[0] = width_image;
					result[1] = height_image;
				} else {
					width_image = width_screen - 60 * density;
					height_image = width_image / ratio_image;
					result[0] = width_image;
					result[1] = height_image;
				}
			}else{
				Log.d("landscape", "landscape");
				if (ratio_image < ratio_screen) {
					height_image = height_screen ;
					width_image = height_image * ratio_image;
					result[0] = width_image;
					result[1] = height_image;
				} else {
					width_image = width_screen;
					height_image = width_image / ratio_image;
					result[0] = width_image;
					result[1] = height_image;
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		
		return result;
	}

	public static float[] getProperSizeForFeaturedImage(Context c,
			Bitmap bitmap) {
		float[] result = new float[2];
		try {
			float width_screen = DeviceUtils.getScreenWidthInPixels(c);

			float width_image = bitmap.getWidth();
			float height_image = bitmap.getHeight();
			float ratio_image = width_image / height_image;

			result[0] = width_screen;
			result[1] = width_screen / ratio_image;
		}catch (Exception e){
			e.printStackTrace();
		}
		return result;
	}

	public static boolean isPackageInstalled(Context context, String packageName) {
		try {
			PackageManager pm = context.getPackageManager();
			pm.getPackageInfo(packageName, PackageManager.GET_ACTIVITIES);
			return true;
		} catch (NameNotFoundException e) {
			return false;
		}
	}

	public static String getPackageName(Context c) {
		try {
			String PACKAGE_NAME = c.getApplicationContext().getPackageName();
			return PACKAGE_NAME;
		}catch (Exception e){
			e.printStackTrace();
			return "";
		}
	}

	public static String checkInstall() {
		return checkInstall;
	}

	@SuppressWarnings("deprecation")
	public static void launchApplication(Activity activity, String packageName , String openUrl) {
		try {
			if (isPackageInstalled(activity, packageName)) {
				checkInstall = "1";
				Intent launchIntent = activity.getPackageManager()
						.getLaunchIntentForPackage(packageName);
				activity.startActivity(launchIntent);

			} else {
				Intent browserIntent = new Intent(Intent.ACTION_VIEW , Uri.parse(openUrl));
				activity.startActivity(browserIntent);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public static int getCurrentDayOfYear() {
		try {
			Calendar c = Calendar.getInstance(TimeZone.getDefault());
			return c.get(Calendar.DAY_OF_YEAR);
		}catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}

	public static byte[] getBytesFromBitmap(Bitmap bitmap) {
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		bitmap.compress(CompressFormat.PNG, 0, stream);
		return stream.toByteArray();
	}

	// convert from byte array to bitmap
	public static Bitmap getBitmapfromBytes(byte[] image) {
		try {
			return BitmapFactory.decodeByteArray(image, 0, image.length);
		}catch (Exception e){
			e.printStackTrace();
			Bitmap bitmap = Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888);
			bitmap.eraseColor(Color.WHITE);
			return bitmap;
		}
	}

	public static boolean isNetworkAvailable(Context context) {
		try {
			ConnectivityManager manager = (ConnectivityManager) context
					.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo networkInfo = manager.getActiveNetworkInfo();
			boolean isAvailable = false;
			if (networkInfo != null && networkInfo.isConnected()) {
				isAvailable = true;
			}
			return isAvailable;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
	
	public static int dpToPx(Context context, int dp) {
	    try {
			DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
			int px = Math.round(dp * (displayMetrics.xdpi / DisplayMetrics.DENSITY_DEFAULT));
			return px;
		}catch (Exception e){
			e.printStackTrace();;
			return 0;
		}
	} 
	
	public static int pxToDp(Context context, int px) {
	    try {
			DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
			int dp = Math.round(px / (displayMetrics.xdpi / DisplayMetrics.DENSITY_DEFAULT));
			return dp;
		}catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	} 
	
	public static void timerDelayEnableDismissProgressDialog(long time, final ProgressDialog d){
	    new Handler().postDelayed(new Runnable() {
	        public void run() {                 
	            try {
					d.setCancelable(true);
				}catch (Exception e){
					e.printStackTrace();
				}
			}
	    }, time); 
	} 
}
