package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;

public class UpdateViewUtils {
	public interface ViewTreeListener {
		void done();
	}

	public static void updatWhenViewTreeLoaded(Context context,
                                               final View view, final ViewTreeListener viewTreeListener) {
		view.getViewTreeObserver().addOnGlobalLayoutListener(
				new OnGlobalLayoutListener() {

					@SuppressWarnings("deprecation")
					@SuppressLint("NewApi") @Override
					public void onGlobalLayout() {
						try {
							if (viewTreeListener != null) {
								viewTreeListener.done();
							}
							if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
								view.getViewTreeObserver()
										.removeGlobalOnLayoutListener(this);
							} else {
								view.getViewTreeObserver()
										.removeOnGlobalLayoutListener(this);
							}
						}catch (Exception e){
							e.printStackTrace();
						}
					}
				});
	}
}
