package com.leafready.ads.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

public final class SharedPreferenceUtils {

	private static final String PREFERENCE_NAME = "ads_Mobilegame";

	/**
	 * Get the instance of SharedPreferences
	 * 
	 * @param context
	 * @return
	 */
	public static SharedPreferences getSharedPreferences(Context context) {
		if(context!=null){
			return context.getSharedPreferences(PREFERENCE_NAME, Context.MODE_PRIVATE);
		}else{
			return null;
		}
	}
	/**
	 * Get string value through key
	 * 
	 * @param context
	 * @param key
	 * @return
	 */
	public static String getStringValue(Context context, String key) {
		try {
			SharedPreferences sharedPreferences = getSharedPreferences(context);
			return sharedPreferences.getString(key, "");
		}catch (Exception e){
			e.printStackTrace();
			return "";
		}
	}
	/**
	 * Save Single String preference
	 * 
	 * @param context
	 * @param key
	 * @param value
	 * @return
	 */
	public static boolean saveStringValue(Context context, String key, String value) {
		try {
			SharedPreferences sharedPreferences = getSharedPreferences(context);
			Editor editor = sharedPreferences.edit();
			editor.putString(key, value);
			return editor.commit();
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
	/**
	 * Save int value
	 * 
	 * @param context
	 * @param key
	 * @param value
	 * @return
	 */
	public static boolean saveIntValue(Context context, String key, int value) {
		try {
			SharedPreferences sharedPreferences = getSharedPreferences(context);
			Editor editor = sharedPreferences.edit();
			editor.putInt(key, value);
			return editor.commit();
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
	
	public static boolean saveBooleanValue(Context context, String key, boolean value) {
		try {
			SharedPreferences sharedPreferences = getSharedPreferences(context);
			Editor editor = sharedPreferences.edit();
			editor.putBoolean(key, value);
			return editor.commit();
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	/**
	 * Get int value
	 * 
	 * @param context
	 * @param key
	 * @param defaultValue
	 * @return
	 */
	public static int getIntValue(Context context, String key, int defaultValue) {
		try {
			SharedPreferences sharedPreferences = getSharedPreferences(context);
			return sharedPreferences.getInt(key, defaultValue);
		}catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}
	
	public static boolean getBooleanValue(Context context, String key, boolean defaultValue) {
		try {
			SharedPreferences sharedPreferences = getSharedPreferences(context);
			return sharedPreferences.getBoolean(key, defaultValue);
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
}
