package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnLongClickListener;
import android.view.View.OnTouchListener;

public class ClickOutsideDetector {
	private static final String TAG = "ClickEventDetector";
	private static float mDownX;
	private static float mDownY;
	private final static float SCROLL_THRESHOLD = 10;
	private static boolean isOnClick = false;

	public interface ClickListener {
		void onClick(View view);
	}

	public static void setOnTouchEvent(ClickListener clickListener,
			View... views) {
		for (int i = 0; i < views.length; i++) {
			setListener(views[i], clickListener);
		}
	}

	public static void setListener(final View view, final ClickListener listener) {
		final View viewFinal = view;

		view.setOnTouchListener(new OnTouchListener() {
			@SuppressLint("ClickableViewAccessibility")
			@Override
			public boolean onTouch(View arg0, MotionEvent ev) {

				try {
					switch (ev.getAction() & MotionEvent.ACTION_MASK) {
						case MotionEvent.ACTION_DOWN:
							mDownX = ev.getX();
							mDownY = ev.getY();
							isOnClick = true;
							break;
						case MotionEvent.ACTION_CANCEL:
						case MotionEvent.ACTION_UP:
							if (isOnClick) {
								LogUtils.log(view.getContext(), TAG, "onClick ");
								if (listener != null) {
									listener.onClick(viewFinal);
								}
							}
							break;

						case MotionEvent.ACTION_MOVE:
							if (isOnClick
									&& (Math.abs(mDownX - ev.getX()) > SCROLL_THRESHOLD || Math
									.abs(mDownY - ev.getY()) > SCROLL_THRESHOLD)) {
								LogUtils.log(view.getContext(), TAG, "movement detected");
								isOnClick = false;
							}
							break;
					}
				}catch (Exception e){
					e.printStackTrace();
				}
				return false;
			}
		});
		view.setOnLongClickListener(new OnLongClickListener() {
			
			@Override
			public boolean onLongClick(View arg0) {
				return false;
			}
		});
	}
}
