package com.leafready.ads.dialogs;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.leafready.ads.OrientationState;
import com.leafready.ads.R;
import com.leafready.ads.adapters.Type24PagerAdapter;
import com.leafready.ads.autoscrollviewpager.AutoScrollViewPager;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.TouchOutSideDialogContentDetector;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.MobileIndicator;

import java.util.ArrayList;

public class Type_2_4_Dialog extends BaseDialog{
	
	private final String TAG = Type_2_4_Dialog.class.getSimpleName();
	protected View rootView;
	protected ImageButton btnClose;
	protected AutoScrollViewPager viewPager;
	protected TextView txtCoin, txtNameGame;
	protected ArrayList<MAdItem> adItems;
	private boolean isEncrypted;
	private LinearLayout layoutGameName;
	private TextView txtDownload;
	private RelativeLayout layoutDownload;
	private Button btnCategoryName;
	private MobileIndicator layoutIndicators;
	private GestureDetector gestureDetector;
	private Type24PagerAdapter adsPagerAdapter;

	public View.OnClickListener onClickListener = new View.OnClickListener() {
		@Override
		public void onClick(View arg0) {
			try {
				MAdItem adItem = adsPagerAdapter.getCurrentItem(viewPager.getCurrentItem());
				if(adItem == null){
					dismiss();
					return;
				}
				Intent browserIntent = new Intent(Intent.ACTION_VIEW, adItem.getExternalUri());
				activity.startActivity(browserIntent);
				dismiss();
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	};


	public Type_2_4_Dialog(Activity activity, MAd model) {
		super(activity, model);
		try {
			gestureDetector = new GestureDetector(activity, new TouchOutSideDialogContentDetector(this));
		}catch (Exception e){
			e.printStackTrace();
		}
	}



	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		try {
			setContentView(R.layout.dialog_popup_2_4_);
			rootView = findViewById(R.id.layout_root);
			btnClose = (ImageButton) findViewById(R.id.btn_close);
			txtNameGame = (TextView) findViewById(R.id.txt_game_name);
			txtCoin = (TextView) findViewById(R.id.txt_Mobilecoin);
			viewPager = (AutoScrollViewPager) findViewById(R.id.view_pager);
			txtDownload = (TextView) findViewById(R.id.txt_download);
			btnCategoryName = (Button) findViewById(R.id.btn_category_game);
			layoutGameName = (LinearLayout) findViewById(R.id.layout_game_name);
			layoutDownload = (RelativeLayout) findViewById(R.id.layout_game_download);
			layoutGameName.setOnClickListener(onClickListener);
			layoutDownload.setOnClickListener(onClickListener);
			btnCategoryName.setOnClickListener(onClickListener);
			isEncrypted = true;
			adItems = model.getAdItems();
			adsPagerAdapter = new Type24PagerAdapter(adItems, isEncrypted,this);
			viewPager.setAdapter(adsPagerAdapter);
			layoutIndicators = (MobileIndicator) findViewById(R.id.layout_indicators);
			layoutIndicators.setViewPager(viewPager);
			View.OnClickListener onClickCloseListener = new View.OnClickListener() {
				public void onClick(View v) {
					dismiss();
				}
			};
			rootView.setOnTouchListener(new OnTouchListener() {

				@SuppressLint("ClickableViewAccessibility")
				@Override
				public boolean onTouch(View view, MotionEvent event) {
					gestureDetector.onTouchEvent(event);
					return true;
				}
			});

			initCoin_NameGame();
			btnClose.setOnClickListener(onClickCloseListener);


			int oRientation = DeviceUtils.getScreenOrientation(activity);
			if (oRientation == OrientationState.LANDSCAPE) {
				if (txtDownload != null && adItems.get(0).getCoin() != 0) {
					int paddingRight = Utils.dpToPx(activity, 20);
					txtDownload.setPadding(0, 0, paddingRight, 0);
				}
			}

			if (model.getAutoSlideTime() > 0) {
				viewPager.setInterval(model.getAutoSlideTime());
				viewPager.startAutoScroll();
			}

			viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {

				@Override
				public void onPageSelected(int position) {
					updateFeatureTitle(position);
				}

				@Override
				public void onPageScrolled(int arg0, float arg1, int arg2) {
				}

				@Override
				public void onPageScrollStateChanged(int arg0) {
				}
			});
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void initCoin_NameGame() {
		try {
			String title;
			boolean isTablet = activity.getResources().getBoolean(R.bool.isTablet);
			if (isTablet) {
				title = adItems.get(0).getTitle();
			} else {
				title = Utils.splitString(adItems.get(0).getTitle());
			}
			txtNameGame.setText(title);
			if (adItems.get(0).getCoin() > 0) {
				txtCoin.setVisibility(View.VISIBLE);
				txtCoin.setText("+" + adItems.get(0).getCoin());
			} else {
				txtCoin.setVisibility(View.INVISIBLE);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void updateFeatureTitle(int index) {
		try {
			for (int i = 0; i < adItems.size(); i++) {
				if (i == index) {
					String title;
					boolean isTablet = activity.getResources().getBoolean(
							R.bool.isTablet);
					if (isTablet) {
						title = adItems.get(0).getTitle();
					} else {
						title = Utils.splitString(adItems.get(0).getTitle());
					}
					txtNameGame.setText(title);
					if (adItems.get(0).getCoin() > 0) {
						txtCoin.setVisibility(View.VISIBLE);
						txtCoin.setText("+" + adItems.get(0).getCoin());
					} else {
						txtCoin.setVisibility(View.INVISIBLE);
					}
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	
	@Override
	public void show() {
		super.show();
		try {
			MAdItem adItem = adItems.get(0);
			if(adItem == null){
				return;
			}

			byte[] bytes = adItem.getBannerData();
			int oRientation = DeviceUtils.getScreenOrientation(activity);
			float[] optimalSize = GifUtils.loadBytesToGifImage(activity, bytes,
					null, oRientation == OrientationState.LANDSCAPE);
			LayoutParams lp = viewPager.getLayoutParams();
			lp.width = (int) optimalSize[0];
			lp.height = (int) optimalSize[1];

			if(lp.width <= 0){
				return;
			}
			viewPager.setLayoutParams(lp);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
}
