package com.leafready.ads.dialogs;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ImageButton;

import com.leafready.ads.R;
import com.leafready.ads.adapters.Type5PagerAdapter;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.ClickOutsideDetector;
import com.leafready.ads.utils.ClickOutsideDetector.ClickListener;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.views.MobileIndicator;

import java.util.ArrayList;

public class Type5Dialog extends BaseDialog {
	private final String TAG = Type5Dialog.class.getSimpleName();
	private ArrayList<MAdItem> adItems;
	private ImageButton btnClose;
	private ViewPager viewPager;

	public int pagerPadding;
	private boolean isEncrypted;
	private MobileIndicator layoutIndicators;
	private Type5PagerAdapter adsPagerAdapter;

	public View.OnClickListener onClickListener = new View.OnClickListener() {
		@Override
		public void onClick(View v) {
			onClickHandler(adsPagerAdapter.getCurrentItem(viewPager.getCurrentItem()));
		}
	};

	public void onClickHandler(MAdItem adItem) {
		try {
			Intent browserIntent = new Intent(Intent.ACTION_VIEW,
					adItem.getExternalUri());
			activity.startActivity(browserIntent);
			Type5Dialog.this.dismiss();
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public Type5Dialog(Activity activity, MAd model) {
		super(activity, model);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		try {
			setContentView(R.layout.dialog_popup_5);
			isEncrypted = true;
			adItems = model.getAdItems();
			viewPager = (ViewPager) findViewById(R.id.overlap_pager);
			viewPager.setClipToPadding(false);
			viewPager.setOffscreenPageLimit(adItems.size());
			adsPagerAdapter = new Type5PagerAdapter(adItems, isEncrypted,this);
			viewPager.setAdapter(adsPagerAdapter);

			ClickOutsideDetector.setListener(viewPager, new ClickListener() {

				@Override
				public void onClick(View view) {
					LogUtils.log(activity, TAG, "click outside ad content");
					dismiss();
				}
			});

			btnClose = (ImageButton) findViewById(R.id.btn_close);
			btnClose.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View v) {
					dismiss();
				}
			});
			layoutIndicators = (MobileIndicator) findViewById(R.id.layout_indicator);
			layoutIndicators.setViewPager(viewPager);
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void updatePadding(){
		try {
			if(pagerPadding == 0){
				return;
			}
			viewPager.setPadding(pagerPadding, 0, pagerPadding, 0);
		}catch (Exception e){
			e.printStackTrace();
		}
	}


}
