package com.leafready.ads.dialogs;

import android.app.Activity;
import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Window;

import com.leafready.ads.models.MAd;

public abstract class BaseDialog extends Dialog {
	
	protected Activity activity;

	public Activity getActivity() {
		return activity;
	}

	protected MAd model;
	
	public BaseDialog(Activity activity, MAd model) {
		super(activity, android.R.style.Theme_Black_NoTitleBar_Fullscreen);
		this.activity = activity;
		this.model = model;
		
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
	}

	@Override
	public void show() {
		super.show();
	}

}
