package com.leafready.ads.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.leafready.ads.OrientationState;
import com.leafready.ads.R;
import com.leafready.ads.dialogs.BaseDialog;
import com.leafready.ads.dialogs.Type_2_4_Dialog;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.views.MobileImageView;

import java.util.ArrayList;

/**
 * Created by hnc on 6/9/2017.
 */

public class Type24PagerAdapter extends PagerAdapter {
    private ArrayList<MAdItem> adsItem;
    private Activity activity;
    private Type_2_4_Dialog dialog;

    public Type24PagerAdapter(ArrayList<MAdItem> listItem, boolean isEncrypted, BaseDialog dialog) {
        adsItem = listItem;
        this.dialog = (Type_2_4_Dialog) dialog;
        activity = dialog.getActivity();
    }
    @SuppressLint("InflateParams")
    @Override
    public Object instantiateItem(ViewGroup container, final int position) {
        // this.position = position;
        View view = LayoutInflater.from(activity).inflate(
                R.layout.item_type_1_to_4, null);
        MobileImageView bannerImage = (MobileImageView) view
                .findViewById(R.id.image_type_1_to_4);
        try {
            byte[] bytes = adsItem.get(position).getBannerData();
            int oRientation = DeviceUtils.getScreenOrientation(activity);
            GifUtils.loadBytesToGifImage(activity, bytes,
                    bannerImage, oRientation == OrientationState.LANDSCAPE);

            bannerImage.setViewListener(new MobileImageView.ImageViewListener() {

                @Override
                public void onLongPress(View view) {
                }

                @Override
                public void onClick(View view) {
                    LogUtils.log(activity, "banner onclick");
                    dialog.onClickListener.onClick(view);
                }

                @Override
                public void onScroll() {

                }

                @Override
                public void onHold() {

                }

                @Override
                public void onHoldRelease() {

                }
            });
            container.addView(view);
        }catch (Exception e){
            e.printStackTrace();
        }
        return view;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        try {
            container.removeView((View) object);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public MAdItem getCurrentItem(int position){
        try {
            return  adsItem.get(position);
        }catch (Exception e){
            e.printStackTrace();
            return new MAdItem();
        }
    }

    @Override
    public int getCount() {
        try {
            return adsItem.size();
        }catch (Exception e){
            return 0;
        }
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        try {
            return (view == object);
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }
}
