package com.leafready.ads;

import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnDismissListener;
import android.content.DialogInterface.OnShowListener;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.leafready.ads.dialogs.Type5Dialog;
import com.leafready.ads.dialogs.Type_1_3_Dialog;
import com.leafready.ads.dialogs.Type_2_4_Dialog;
import com.leafready.ads.models.MAd;
import com.leafready.ads.models.MAdItem;
import com.leafready.ads.utils.Constants;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.GifUtils;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.utils.NetUtils;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.GifImageView;

import com.google.android.gms.ads.*;
import com.google.android.gms.ads.AdListener;

import java.util.ArrayList;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PopupAd extends AbstractAd {

	private static final String TAG = PopupAd.class.getSimpleName();
	private boolean debugMode = false;

	private Activity activity;
	private InterstitialAd mInterstitialAd;

	private Dialog dialog;

	private MAd model;

	private int countLoadedBanners;

	private String apiDebugUrl;

	public PopupAd(Activity activity) {
		this.activity = activity;
		DeviceUtils.saveMarResolution(activity);
	}

	public void enableDebug(boolean enable) {
		this.debugMode = enable;
	}

	public boolean isDebugMode() {
		return this.debugMode;
	}

	public void setApiDebugUrl(String apiUrl) {
		this.apiDebugUrl = apiUrl;
	}

	@Override
	public void loadAd() {
		try {
			Log.i(TAG, "loadAd");
			if (!isLoading() && Utils.isNetworkAvailable(activity)) {
				try {
					adStatus = Status.LOADING;
					if (debugMode) {
						NetUtils.getAsyc(activity, this.apiDebugUrl,
								mResultListener, true);
					} else {
						NetUtils.getAsyc(activity, Constants.URL_GET_POPUP,
								mResultListener, true);
					}
				} catch (Exception e) {
					e.printStackTrace();
					adStatus = Status.ERROR;
					if (adListener != null) {
						adListener.onAdLoadedError(ERROR_CONNECTION,
								"Connection error");
					}
				}
			} else {
				adStatus = Status.ERROR;
				if (adListener != null) {
					adListener
							.onAdLoadedError(ERROR_CONNECTION, "Connection error");
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	@Override
	public void show() {
		try {
			if (!Utils.isNetworkAvailable(activity)) {
				adStatus = Status.ERROR;
				if (adListener != null) {
					adListener.onAdLoadedError(ERROR_CONNECTION,
							"please check your network!");
				}
				return;
			}
		
			if (model == null) {
				adStatus = Status.ERROR;
				if (adListener != null) {
					adListener.onAdLoadedError(ERROR_CORRUPTED,
							"Double loaded , again!!");
				}
				return;
			}
			
			if (model.getStatus() == 2) {
				showAdmob();
			} else if (model.getStatus() == 1) {
				if (isLoaded() && !isShowing()) {
					doShow();
				}
			} else {
				adStatus = Status.ERROR;
				if (adListener != null) {
					adListener.onAdLoadedError(ERROR_CONNECTION,
							"Connection error");
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
			adStatus = Status.ERROR;
			if(adListener != null){
				adListener.onAdLoadedError(ERROR_SERVER, "Ad load failed!");	
			}
			return;
		}
	};

	@Override
	protected boolean isShowing() {
		try {
			return dialog != null && dialog.isShowing();
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	@Override
	protected void close() {
		try{
			if (dialog != null) {
				dialog.dismiss();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void doShow() {

		try {
			switch (model.getPopupType()) {
				case 1:
					dialog = new Type_1_3_Dialog(activity, model);
					break;
				case 2:
					dialog = new Type_2_4_Dialog(activity, model);
					break;
				case 3:
					dialog = new Type_1_3_Dialog(activity, model);
					break;
				case 4:
					dialog = new Type_2_4_Dialog(activity, model);
					break;
				case 5:
					dialog = new Type5Dialog(activity, model);
					break;
			}

			if (dialog == null) {
				adStatus = Status.ERROR;
				if (adListener != null) {
					adListener.onAdLoadedError(ERROR_CORRUPTED, "Ad load failed!");
				}
				return;
			}

			dialog.setOnShowListener(new OnShowListener() {
				public void onShow(DialogInterface dialog) {
					if (adListener != null) {
						adListener.onAdOpened();
						try {
							NetUtils.postAsyc(activity , model.getShowAdsUrl() , true);
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				}
			});

			dialog.setOnDismissListener(new OnDismissListener() {
				public void onDismiss(DialogInterface dialog) {
					if (adListener != null) {
						adListener.onAdClosed();
					}
				}
			});
			dialog.show();
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private Callback<ResponseBody> mResultListener = new Callback<ResponseBody>() {

		private String jsonStr;

		@Override
		public void onResponse(Call<ResponseBody> caller,
				Response<ResponseBody> response) {
			try {
				jsonStr = response.body().string();
				LogUtils.log(activity, TAG, "onPostExecute:" + jsonStr);

				model = new MAd(jsonStr);

				switch (model.getStatus()) {
				case 1:
					countLoadedBanners = 0;
					for (int i = 0; i < model.getAdItems().size()
							&& adStatus != Status.ERROR; i++) {
						final MAdItem adItem = model.getAdItems().get(i);
						String bannerUrl = adItem.getBannerUrl();

						Glide.with(activity).as(byte[].class).load(bannerUrl).into(new SimpleTarget<byte[]>() {

							@Override
							public void onResourceReady(@NonNull byte[] imageBytesData, @Nullable Transition<? super byte[]> transition) {
								if (imageBytesData == null) {
									adStatus = Status.ERROR;
									if(adListener != null){
										adListener.onAdLoadedError(
												ERROR_SERVER,
												"Ad load failed!");
									}
									return;
								}

								if (imageBytesData.length <= 0) {
									adStatus = Status.ERROR;
									if(adListener != null){
										adListener.onAdLoadedError(
												ERROR_SERVER,
												"Ad load failed!");
									}
									return;
								}
								adItem.setBannerData(imageBytesData);
								countLoadedBanners++;

								if (countLoadedBanners == model
										.getAdItems().size()) {
									adStatus = Status.LOADED;
									if (adListener != null) {
										adListener.onAdLoaded();
									}
								} else if (countLoadedBanners >= 1) {
									adStatus = Status.PARTIAL_LOADED;
								}
							}


							public void onLoadFailed( // TODO meo biet cai nay se dc goi ntn, hinh nhu no bo~ load failed roi.
									Exception e,
									android.graphics.drawable.Drawable errorDrawable) {
								adStatus = Status.ERROR;
								if(adListener != null){
									adListener
											.onAdLoadedError(ERROR_SERVER,
													"Ad load failed!");
								}
								return;
							};
						});
					}
					break;
				case 2:
					initAdmob(activity, model.getPubKeyAdmob());
					loadAdmob();
					break;
				default:
//					stopTimeoutTimer();
					adStatus = Status.ERROR;
					if (adListener != null) {
						String message = "Error!!!";
						if (model.hasError()) {
							message = model.getError();
						}
						adListener.onAdLoadedError(ERROR_SERVER, message);
					}
				}

			} catch (Exception e) {
//				stopTimeoutTimer();
				adStatus = Status.ERROR;
				if (adListener != null) {
					adListener.onAdLoadedError(ERROR_CORRUPTED, e.getMessage());
				}
			}
		}

		@Override
		public void onFailure(Call<ResponseBody> arg0, Throwable error) {
			// TODO Auto-generated method stub
			try {
				adStatus = Status.ERROR;
				if (adListener != null) {
					adListener.onAdLoadedError(ERROR_CORRUPTED, error.getMessage());
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	};

//	private void stopTimeoutTimer() {
//		// stop timeout timer
//		if (timeoutHandler != null) {
//			timeoutHandler.removeCallbacks(null);
//		}
//	}

	@Override
	void loadBytesToGifImageView(Activity a, byte[] bytes,
                                 GifImageView imageView) {
		try {
			if (!GifUtils.isGif(bytes)) {
				Bitmap bitmap = Utils.getBitmapfromBytes(bytes);
				float[] resizeImage = Utils.getProperSizeForIntertitialImage(a,
						bitmap);
				Bitmap newBitmap = Bitmap.createScaledBitmap(bitmap,
						(int) resizeImage[0], (int) resizeImage[1], true);
				imageView.setImageBitmap(newBitmap);
			} else {
				imageView.setBytes(bytes);
				imageView.startAnimation();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void initAdmob(Activity activity, String admobUnitId) {
		try {
			mInterstitialAd = new InterstitialAd(activity);
			mInterstitialAd.setAdUnitId(admobUnitId);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void loadAdmob() {
		try {
			if (mInterstitialAd != null && !mInterstitialAd.isLoaded()) {
				AdRequest adRequest = new AdRequest.Builder().build();
				adStatus = Status.LOADING;
				mInterstitialAd.setAdListener(new AdListener() {

					@Override
					public void onAdFailedToLoad(int errorCode) {
						super.onAdFailedToLoad(errorCode);
						adStatus = Status.ERROR;
						if (adListener != null) {
							adListener.onAdLoadedError(errorCode, "Admob error");
						}
					}

					@Override
					public void onAdLoaded() {
						super.onAdLoaded();

						adStatus = Status.LOADED;
						if (adListener != null) {
							adListener.onAdLoaded();
						}
					}

					@Override
					public void onAdOpened() {
						super.onAdOpened();
						if (adListener != null) {
							adListener.onAdOpened();
						}
					}

					@Override
					public void onAdClosed() {
						super.onAdClosed();
						if (adListener != null) {
							adListener.onAdClosed();
						}
					}

				});
				mInterstitialAd.loadAd(adRequest);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void showAdmob() {
		try {
			if (mInterstitialAd != null && mInterstitialAd.isLoaded()) {
				mInterstitialAd.show();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public ArrayList<String> getListImageUrl() {
		ArrayList<String> images = new ArrayList<String>();
		try {
			for (MAdItem adItem : model.getAdItems()) {
				images.add(adItem.getBannerUrl());
			}
			return images;
		}catch (Exception e){
			e.printStackTrace();
			return images;
		}
	}

}
