/*
 * Decompiled with CFR 0.152.
 */
package com.lazylibs.updater.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.ResponseBody;

public class VersionUpdateUtils {
    public static void showToast(Context context, String string) {
        Toast.makeText((Context)context, (CharSequence)string, (int)0).show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeResponseBodyToDisk(String string, ResponseBody responseBody) {
        File file;
        OutputStream outputStream;
        block13: {
            Log.d((String)"VersionUpdateUtils", (String)("contentType:>>>>" + responseBody.contentType().toString()));
            Log.d((String)"VersionUpdateUtils", (String)("path:>>>>" + string));
            File file2 = new File(string);
            InputStream inputStream = null;
            outputStream = null;
            try {
                int n;
                byte[] byArray = new byte[4096];
                inputStream = responseBody.byteStream();
                outputStream = new FileOutputStream(file2);
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                outputStream.flush();
                file = file2;
                if (inputStream == null) break block13;
            }
            catch (IOException iOException) {
                File file3;
                block14: {
                    try {
                        iOException.printStackTrace();
                        file3 = null;
                        if (inputStream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                            return null;
                        }
                    }
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                return file3;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        return file;
    }

    public static boolean checkAPKIsExists(Context context, String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.exists()) {
            try {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageArchiveInfo(string, 1);
                Log.e((String)"HFL-upd", (String)("ApkFile version\uff1a" + packageInfo.versionCode + "\n Current App version\uff1a" + context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode));
                if (context.getPackageName().equalsIgnoreCase(packageInfo.packageName) && context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode != packageInfo.versionCode) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    private static boolean a(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getAppVersionName(Context context) {
        return VersionUpdateUtils.getAppVersionName(context, context.getPackageName());
    }

    public static String getAppVersionName(Context context, String string) {
        if (VersionUpdateUtils.a(string)) {
            return null;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            return packageInfo == null ? null : packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null || connectivityManager.getActiveNetworkInfo() == null) {
            return false;
        }
        return connectivityManager.getActiveNetworkInfo().getType() == 1;
    }

    public static void installApp(Context context, File file, String string) {
        Uri uri;
        if (file == null || !file.exists() || !file.isFile()) {
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String string2 = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT < 24) {
            uri = Uri.fromFile((File)file);
        } else {
            intent.setFlags(1);
            uri = FileProvider.getUriForFile((Context)context, (String)string, (File)file);
        }
        intent.setDataAndType(uri, string2);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static String apkDir(@NonNull Context context) {
        return context.getCacheDir().getAbsolutePath() + "/";
    }

    public static String apkFile(String string) {
        return "v" + string + ".apk";
    }

    public static void chmod(String string) {
        String[] stringArray = new String[]{"chmod", "777", string};
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        try {
            processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void cleanApk(String string) {
        File file = new File(string);
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    if (!file2.isFile() || !file2.getName().endsWith(".apk")) continue;
                    file2.delete();
                }
            }
        } else {
            file.mkdir();
        }
        if (!(!file.exists() || file.canWrite() && file.canRead())) {
            VersionUpdateUtils.chmod(file.getAbsolutePath());
        }
    }
}

