/*
 * Decompiled with CFR 0.152.
 */
package com.lazylibs.updater;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.widget.Toast;
import com.lazylibs.updater.R;
import com.lazylibs.updater.VersionUpdateService;
import com.lazylibs.updater.interfaces.IUpgradeModel;
import com.lazylibs.updater.model.DownloadProgress;
import com.lazylibs.updater.model.DownloadResponseBody;
import com.lazylibs.updater.model.UpdateResult;
import com.lazylibs.updater.utils.VersionUpdateUtils;
import com.lazylibs.updater.view.DownloadProgressDialogFragment;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public class VersionUpdateHelper
implements ServiceConnection {
    private Context a;
    private AlertDialog b;
    private IUpgradeModel c;
    private VersionUpdateService d;
    private VersionHelperListener e;
    private DownloadProgressDialogFragment f;
    private boolean g = false;
    private boolean h = false;

    public static VersionUpdateHelper create(@NonNull Activity activity, @NonNull VersionHelperListener versionHelperListener, IUpgradeModel iUpgradeModel) {
        return new VersionUpdateHelper(activity, versionHelperListener, iUpgradeModel).h();
    }

    public static VersionUpdateHelper create(@NonNull Activity activity, @NonNull VersionHelperListener versionHelperListener) {
        return new VersionUpdateHelper(activity, versionHelperListener).h();
    }

    public static void destroy(VersionUpdateHelper versionUpdateHelper) {
        if (versionUpdateHelper != null) {
            versionUpdateHelper.a(UpdateResult.Destroy);
            if (versionUpdateHelper.i()) {
                versionUpdateHelper = null;
            }
        }
    }

    private static void b(VersionUpdateHelper versionUpdateHelper, UpdateResult updateResult) {
        if (versionUpdateHelper != null) {
            versionUpdateHelper.a(updateResult);
            if (versionUpdateHelper.i()) {
                versionUpdateHelper = null;
            }
        }
    }

    private void a(UpdateResult updateResult) {
        if (this.e != null) {
            this.e.vHelperCallBack(updateResult);
        }
    }

    public void setToast(boolean bl) {
        this.h = bl;
    }

    public void doHasVersionModel(IUpgradeModel iUpgradeModel) {
        if (iUpgradeModel == null || this.b() || this.c() || !this.g) {
            return;
        }
        this.c = iUpgradeModel;
        this.c.setNeedUpgrade(VersionUpdateUtils.getAppVersionName((Context)this.d));
        if (!this.c.isNeedUpgrade()) {
            VersionUpdateHelper.b(this, UpdateResult.Success);
            return;
        }
        if (this.a == null) {
            return;
        }
        this.e();
    }

    private void a() {
        if (this.c == null) {
            return;
        }
        if (!this.c.isNeedUpgrade()) {
            if (this.h) {
                Toast.makeText((Context)this.a, (int)R.string.updater_no_new_version, (int)0).show();
            }
            VersionUpdateHelper.b(this, UpdateResult.Success);
            return;
        }
        if (this.a == null) {
            return;
        }
        this.b = this.f();
        this.b.show();
    }

    private VersionUpdateHelper(@NonNull Activity activity, @NonNull VersionHelperListener versionHelperListener, IUpgradeModel iUpgradeModel) {
        this(activity, versionHelperListener);
        this.c = iUpgradeModel;
    }

    private VersionUpdateHelper(@NonNull Activity activity, @NonNull VersionHelperListener versionHelperListener) {
        this.a = activity;
        this.e = versionHelperListener;
    }

    private boolean b() {
        return this.b != null && this.b.isShowing();
    }

    private boolean c() {
        return this.d != null && this.d.isDownloading();
    }

    private void a(final @NonNull File file) {
        if (!TextUtils.isEmpty((CharSequence)file.getAbsolutePath())) {
            VersionUpdateUtils.chmod(file.getAbsolutePath());
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    VersionUpdateUtils.installApp(VersionUpdateHelper.this.a.getApplicationContext(), file, VersionUpdateHelper.this.a.getPackageName() + ".provider");
                    VersionUpdateHelper.b(VersionUpdateHelper.this, UpdateResult.Success);
                }
            }, 10L);
        }
    }

    private void d() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.a);
        builder.setTitle(R.string.updater_found_new_version);
        builder.setMessage(R.string.updater_unwifi_tips);
        builder.setNegativeButton(R.string.updater_download_later, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
                VersionUpdateHelper.b(VersionUpdateHelper.this, UpdateResult.Cancel);
            }
        });
        builder.setPositiveButton(R.string.updater_continue_download, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
                VersionUpdateHelper.this.g();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    private void e() {
        if (VersionUpdateUtils.isWifi(this.a)) {
            this.g();
        } else {
            this.d();
        }
    }

    private AlertDialog f() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.a);
        builder.setTitle(R.string.updater_version_upgrade);
        builder.setMessage((CharSequence)this.c.getUpdateInfo());
        builder.setPositiveButton(R.string.updater_update_now, (dialogInterface, n) -> {
            dialogInterface.cancel();
            this.e();
        });
        if (!this.c.isForceUpdate()) {
            builder.setNegativeButton(R.string.updater_dont_update, (dialogInterface, n) -> {
                dialogInterface.cancel();
                VersionUpdateHelper.b(this, UpdateResult.Cancel);
            });
        }
        builder.setCancelable(false);
        return builder.create();
    }

    private void g() {
        String string2 = VersionUpdateUtils.apkDir(this.a);
        String string3 = string2 + VersionUpdateUtils.apkFile(this.c.getNewVersionName());
        File file = new File(string3);
        if (VersionUpdateUtils.checkAPKIsExists(this.a, string3)) {
            this.a(file);
        } else {
            VersionUpdateUtils.cleanApk(string2);
            this.d.downloadApk(this.c.getDownloadUrl(), string3, new DownloadApkListener(){

                @Override
                public void onStart() {
                    if (VersionUpdateHelper.this.a != null && VersionUpdateHelper.this.a instanceof FragmentActivity) {
                        if (VersionUpdateHelper.this.f == null) {
                            VersionUpdateHelper.this.f = DownloadProgressDialogFragment.newInstance(VersionUpdateHelper.this.c.isForceUpdate());
                        }
                        VersionUpdateHelper.this.f.show(((FragmentActivity)VersionUpdateHelper.this.a).getSupportFragmentManager(), "loading");
                    }
                }

                @Override
                public void onSuccess(File file) {
                    if (VersionUpdateHelper.this.f != null) {
                        VersionUpdateHelper.this.f.dismissAllowingStateLoss();
                    }
                    VersionUpdateHelper.this.a(file);
                }

                @Override
                public void onError(Throwable throwable) {
                    if (VersionUpdateHelper.this.f != null) {
                        VersionUpdateHelper.this.f.dismissAllowingStateLoss();
                    }
                    VersionUpdateHelper.b(VersionUpdateHelper.this, UpdateResult.Error);
                }

                @Override
                public void updateProgress(DownloadProgress downloadProgress) {
                    if (VersionUpdateHelper.this.f != null) {
                        VersionUpdateHelper.this.f.updateProgress(downloadProgress);
                    }
                }
            });
        }
    }

    private VersionUpdateHelper h() {
        if (this.b() || this.c()) {
            return this;
        }
        if (this.d == null && this.a != null) {
            this.a.bindService(new Intent(this.a, VersionUpdateService.class), (ServiceConnection)this, 1);
        }
        return this;
    }

    private boolean i() {
        if (this.b() || this.c()) {
            return false;
        }
        if (!this.g) {
            return false;
        }
        if (this.d != null && !this.d.isDownloading()) {
            this.a.unbindService((ServiceConnection)this);
            this.g = false;
        }
        if (this.a != null && this.c != null && this.c.isForceUpdate()) {
            Process.killProcess((int)Process.myPid());
        }
        return true;
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        this.d = ((VersionUpdateService.a)iBinder).a();
        this.g = true;
        if (this.c != null) {
            this.c.setNeedUpgrade(VersionUpdateUtils.getAppVersionName((Context)this.d));
            this.a();
        }
        if (this.e != null) {
            this.e.sConnectState(1);
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        if (this.f != null) {
            this.f.dismissAllowingStateLoss();
        }
        if (this.b != null && this.b.isShowing()) {
            this.b.cancel();
        }
        this.f = null;
        this.b = null;
        this.d = null;
        this.c = null;
        this.a = null;
        if (this.e != null) {
            this.e.sConnectState(0);
        }
        this.e = null;
    }

    public static interface VersionHelperListener {
        public void sConnectState(int var1);

        public void vHelperCallBack(UpdateResult var1);
    }

    public static interface DownloadApkListener
    extends DownloadResponseBody.DownloadProgressListener {
        public void onStart();

        public void onSuccess(File var1);

        public void onError(Throwable var1);
    }
}

