/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.JMeterMojo;
import com.lazerycode.jmeter.UtilityFunctions;
import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.configuration.RemoteArgumentsArrayBuilder;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.DirectoryScanner;

public class TestManager
extends JMeterMojo {
    private final JMeterArgumentsArray baseTestArgs;
    private final File binDir;
    private final File testFilesDirectory;
    private final List<String> testFilesIncluded;
    private final List<String> testFilesExcluded;
    private final boolean suppressJMeterOutput;
    private final RemoteConfiguration remoteServerConfiguration;
    private final JMeterProcessJVMSettings jMeterProcessJVMSettings;

    public TestManager(JMeterArgumentsArray baseTestArgs, File testFilesDirectory, List<String> testFilesIncluded, List<String> testFilesExcluded, RemoteConfiguration remoteServerConfiguration, boolean suppressJMeterOutput, File binDir, JMeterProcessJVMSettings jMeterProcessJVMSettings) {
        this.binDir = binDir;
        this.baseTestArgs = baseTestArgs;
        this.testFilesDirectory = testFilesDirectory;
        this.testFilesIncluded = testFilesIncluded;
        this.testFilesExcluded = testFilesExcluded;
        this.remoteServerConfiguration = remoteServerConfiguration;
        this.suppressJMeterOutput = suppressJMeterOutput;
        this.jMeterProcessJVMSettings = jMeterProcessJVMSettings;
    }

    public List<String> executeTests() throws MojoExecutionException {
        JMeterArgumentsArray thisTestArgs = this.baseTestArgs;
        List<String> tests = this.generateTestList();
        ArrayList<String> results = new ArrayList<String>();
        for (String file : tests) {
            if (this.remoteServerConfiguration != null) {
                if (this.remoteServerConfiguration.isStartServersBeforeTests() && tests.get(0).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                    thisTestArgs.setRemoteStart();
                    thisTestArgs.setRemoteStartServerList(this.remoteServerConfiguration.getServerList());
                }
                if (this.remoteServerConfiguration.isStopServersAfterTests() && tests.get(tests.size() - 1).equals(file) || this.remoteServerConfiguration.isStartAndStopServersForEachTest()) {
                    thisTestArgs.setRemoteStop();
                }
            }
            results.add(this.executeSingleTest(new File(this.testFilesDirectory, file), thisTestArgs));
        }
        return results;
    }

    private String executeSingleTest(File test, JMeterArgumentsArray testArgs) throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        testArgs.setTestFile(test);
        new File(testArgs.getResultsLogFileName()).delete();
        List<String> argumentsArray = testArgs.buildArgumentsArray();
        argumentsArray.addAll(this.buildRemoteArgs(this.remoteServerConfiguration));
        this.getLog().debug((CharSequence)("JMeter is called with the following command line arguments: " + UtilityFunctions.humanReadableCommandLineOutput(argumentsArray)));
        this.getLog().info((CharSequence)("Executing test: " + test.getName()));
        JMeterProcessBuilder JMeterProcessBuilder2 = new JMeterProcessBuilder(this.jMeterProcessJVMSettings);
        JMeterProcessBuilder2.setWorkingDirectory(this.binDir);
        JMeterProcessBuilder2.addArguments(argumentsArray);
        try {
            int jMeterExitCode;
            Process process = JMeterProcessBuilder2.startProcess();
            if (!this.suppressJMeterOutput) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = br.readLine()) != null) {
                    this.getLog().info((CharSequence)line);
                }
            }
            if ((jMeterExitCode = process.waitFor()) != 0) {
                throw new MojoExecutionException("Test failed");
            }
            this.getLog().info((CharSequence)("Completed Test: " + test.getName()));
        }
        catch (InterruptedException ex) {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"System Exit Detected!  Stopping Test...");
            this.getLog().info((CharSequence)" ");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
        return testArgs.getResultsLogFileName();
    }

    private List<String> buildRemoteArgs(RemoteConfiguration remoteConfig) {
        if (remoteConfig == null) {
            return Collections.emptyList();
        }
        return new RemoteArgumentsArrayBuilder().buildRemoteArgumentsArray(remoteConfig.getMasterPropertiesMap());
    }

    private List<String> generateTestList() {
        String[] stringArray;
        ArrayList<String> jmeterTestFiles = new ArrayList<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testFilesDirectory);
        if (this.testFilesIncluded == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "**/*.jmx";
        } else {
            stringArray = this.testFilesIncluded.toArray(new String[jmeterTestFiles.size()]);
        }
        scanner.setIncludes(stringArray);
        if (this.testFilesExcluded != null) {
            scanner.setExcludes(this.testFilesExcluded.toArray(new String[this.testFilesExcluded.size()]));
        }
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        jmeterTestFiles.addAll(includedFiles);
        return jmeterTestFiles;
    }
}

