/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.properties;

import com.lazerycode.jmeter.JMeterMojo;
import com.lazerycode.jmeter.properties.ReservedProperties;
import java.util.Map;
import java.util.Properties;

class PropertyFileMerger
extends JMeterMojo {
    PropertyFileMerger() {
    }

    public Properties mergePropertiesFiles(Properties source, Properties additions) {
        if (null == source && null == additions) {
            return new Properties();
        }
        if (null == source) {
            return this.stripReservedProperties(additions);
        }
        if (null == additions) {
            return this.stripReservedProperties(source);
        }
        source.putAll((Map<?, ?>)additions);
        return this.stripReservedProperties(source);
    }

    public Properties mergeProperties(Map<String, String> customProperties, Properties baseProperties) {
        if (customProperties != null && !customProperties.isEmpty()) {
            for (String key : customProperties.keySet()) {
                baseProperties.setProperty(key, customProperties.get(key));
                this.warnUserOfPossibleErrors(key, baseProperties);
            }
        }
        return this.stripReservedProperties(baseProperties);
    }

    private Properties stripReservedProperties(Properties propertyFile) {
        for (ReservedProperties reservedProperty : ReservedProperties.values()) {
            if (!propertyFile.containsKey(reservedProperty.getPropertyKey())) continue;
            propertyFile.remove(reservedProperty.getPropertyKey());
            this.getLog().warn((CharSequence)("Unable to set '" + reservedProperty.getPropertyKey() + "', it is a reserved property in the jmeter-maven-plugin"));
        }
        return propertyFile;
    }

    private void warnUserOfPossibleErrors(String value, Properties baseProperties) {
        for (String key : baseProperties.stringPropertyNames()) {
            if (key.equals(value) || !key.toLowerCase().equals(value.toLowerCase())) continue;
            this.getLog().warn((CharSequence)("You have set a property called '" + value + "' which is very similar to '" + key + "'!"));
        }
    }
}

