/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.writer;

import com.google.common.annotations.VisibleForTesting;
import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import com.lazerycode.jmeter.analyzer.util.TemplateUtil;
import com.lazerycode.jmeter.analyzer.writer.WriterBase;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public abstract class TextWriterBase
extends WriterBase {
    @Override
    public void write(Map<String, AggregatedResponses> testResults) throws IOException, TemplateException {
        Writer out = this.getWriter(this.getFile(this.getFileName()));
        this.renderText(testResults, this.getRootTemplate(), out);
        out.flush();
        out.close();
    }

    @VisibleForTesting
    protected Writer getWriter(File file) throws IOException {
        return new FileWriter(file);
    }

    protected abstract String getRootTemplate();

    protected void renderText(Map<String, ?> testResults, String rootTemplate, Writer out) throws IOException, TemplateException {
        Map<String, Object> rootMap = TemplateUtil.getRootMap(testResults);
        rootMap.put("SUMMARY_FILE_NAME", this.fileName);
        Template root = TemplateUtil.getTemplate(rootTemplate);
        root.process(rootMap, out);
    }
}

