/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer;

import com.lazerycode.jmeter.analyzer.ResultAnalyzer;
import com.lazerycode.jmeter.analyzer.config.Environment;
import com.lazerycode.jmeter.analyzer.config.RequestGroup;
import com.lazerycode.jmeter.analyzer.writer.ChartWriter;
import com.lazerycode.jmeter.analyzer.writer.DetailsToCsvWriter;
import com.lazerycode.jmeter.analyzer.writer.DetailsToHtmlWriter;
import com.lazerycode.jmeter.analyzer.writer.HtmlWriter;
import com.lazerycode.jmeter.analyzer.writer.SummaryJsonFileWriter;
import com.lazerycode.jmeter.analyzer.writer.SummaryTextToFileWriter;
import com.lazerycode.jmeter.analyzer.writer.SummaryTextToStdOutWriter;
import com.lazerycode.jmeter.analyzer.writer.Writer;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.SAXException;

@Mojo(name="analyze")
public class AnalyzeMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String source;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(defaultValue="50000")
    private int maxSamples = 50000;
    @Parameter(defaultValue="false")
    private boolean processAllFilesFound;
    @Parameter(defaultValue="false")
    private boolean preserveDirectories;
    @Parameter
    private Set<String> sampleNames = new HashSet<String>(Arrays.asList("httpSample", "sample"));
    @Parameter
    private List<RequestGroup> requestGroups;
    @Parameter
    private Properties remoteResources;
    @Parameter
    private File templateDirectory;
    @Parameter
    private List<Writer> writers;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" A N A L Y S I N G    J M E T E R    R E S U L T S");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" ");
        this.initializeEnvironment();
        try {
            CustomPathMatchingResourcePatternResolver resolver = new CustomPathMatchingResourcePatternResolver();
            Resource[] resultDataFiles = resolver.getResources("file:" + this.source);
            String rootPath = resolver.getRootDir(this.source);
            if (resultDataFiles.length == 0) {
                throw new MojoExecutionException("Property source not set correctly, no JMeter Result XML file found matching " + this.source);
            }
            for (int dataFileIdentifier = 0; dataFileIdentifier < resultDataFiles.length && (dataFileIdentifier != 1 || this.processAllFilesFound); ++dataFileIdentifier) {
                File resultDataFile = resultDataFiles[dataFileIdentifier].getFile();
                this.getLog().info((CharSequence)("Analysing '" + resultDataFile.getName() + "'..."));
                this.analyze(resultDataFile, rootPath);
                this.getLog().info((CharSequence)("Results Generated for '" + resultDataFile.getName() + "'."));
                this.getLog().info((CharSequence)" ");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error analysing", e);
        }
    }

    private void initializeEnvironment() throws MojoExecutionException {
        if (this.writers != null) {
            if (this.writers.contains(null)) {
                throw new MojoExecutionException("One of the configured writers could not be found by Maven.");
            }
        } else {
            this.writers = new ArrayList<Writer>();
            this.writers.add(new SummaryTextToStdOutWriter());
            this.writers.add(new SummaryTextToFileWriter());
            this.writers.add(new SummaryJsonFileWriter());
            this.writers.add(new HtmlWriter());
            this.writers.add(new DetailsToCsvWriter());
            this.writers.add(new DetailsToHtmlWriter());
            this.writers.add(new ChartWriter());
        }
        Environment.ENVIRONMENT.setWriters(this.writers);
        Environment.ENVIRONMENT.setGenerateCharts(this.writers.contains(new ChartWriter()));
        Environment.ENVIRONMENT.setGenerateDetails(this.writers.contains(new DetailsToHtmlWriter()));
        Environment.ENVIRONMENT.setMaxSamples(this.maxSamples);
        Environment.ENVIRONMENT.setRemoteResources(this.remoteResources);
        Environment.ENVIRONMENT.setRequestGroups(this.requestGroups);
        Environment.ENVIRONMENT.setTemplateDirectory(this.templateDirectory);
        Environment.ENVIRONMENT.setTargetDirectory(this.targetDirectory);
        Environment.ENVIRONMENT.initializeFreemarkerConfiguration();
        Environment.ENVIRONMENT.setPreserveDirectories(this.preserveDirectories);
        Environment.ENVIRONMENT.setLog(this.getLog());
        Environment.ENVIRONMENT.setSampleNames(this.sampleNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze(File resultDataFile, String rootPath) throws IOException, SAXException, TemplateException {
        InputStreamReader resultData = resultDataFile.getName().endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new FileInputStream(resultDataFile))) : new FileReader(resultDataFile);
        try {
            String resultDataFileName = resultDataFile.getName();
            String relativePath = null;
            if (this.preserveDirectories) {
                relativePath = resultDataFile.getAbsolutePath().replace(rootPath, "").replace(resultDataFileName, "");
            }
            resultDataFileName = resultDataFileName.substring(0, resultDataFileName.lastIndexOf(46));
            ResultAnalyzer reportAnalyser = new ResultAnalyzer(relativePath, resultDataFileName);
            reportAnalyser.analyze(resultData);
        }
        finally {
            ((Reader)resultData).close();
        }
    }

    private static class CustomPathMatchingResourcePatternResolver
    extends PathMatchingResourcePatternResolver {
        private CustomPathMatchingResourcePatternResolver() {
        }

        public String getRootDir(String pattern) {
            return super.determineRootDir(pattern);
        }
    }
}

