/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.appium.mojo;

import com.lazerycode.appium.configuration.AppiumArguments;
import com.lazerycode.appium.mojo.AbstractAppiumMojo;
import com.lazerycode.appium.utility.UtilityFunctions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.Os;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.Processes;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartAppiumMojo
extends AbstractAppiumMojo {
    @Parameter(defaultValue="${project.basedir}/src/test/resources/node")
    File nodeDefaultLocation;
    @Parameter(defaultValue="${project.basedir}/src/test/resources/node_modules/appium")
    File appiumLocation;
    @Parameter(defaultValue="30")
    int appiumStartupTicks;
    @Parameter(defaultValue="0.0.0.0")
    String appiumIpAddress;
    @Parameter(defaultValue="4723")
    String appiumPort;
    @Parameter
    String selendroidPort;
    @Parameter
    String chromedriverPort;
    @Parameter
    String robotIpAddress;
    @Parameter
    String robotPort;
    static final String NODE_EXECUTABLE_WINDOWS = "node.exe";
    static final String NODE_EXECUTABLE_NIX = "node";

    @Override
    public void controlAppiumServer() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" S T A R T I N G   A P P I U M   S E R V E R");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" ");
        this.getLog().debug((CharSequence)("Using Node location: " + this.nodeDefaultLocation));
        this.getLog().debug((CharSequence)("Using Appium location: " + this.appiumLocation));
        String nodeBinaryName = Os.isFamily((String)"windows") ? NODE_EXECUTABLE_WINDOWS : NODE_EXECUTABLE_NIX;
        File nodeExecutable = new File(this.nodeDefaultLocation, nodeBinaryName);
        UtilityFunctions.checkFileExists(nodeExecutable);
        UtilityFunctions.checkFileExists(this.appiumLocation);
        ArrayList<String> appiumCommandLineArguments = new ArrayList<String>();
        appiumCommandLineArguments.add(nodeExecutable.getAbsolutePath());
        appiumCommandLineArguments.add(this.appiumLocation.getAbsolutePath());
        appiumCommandLineArguments.add(AppiumArguments.ADDRESS.getCommandLineArgument());
        appiumCommandLineArguments.add(this.appiumIpAddress);
        appiumCommandLineArguments.add(AppiumArguments.PORT.getCommandLineArgument());
        appiumCommandLineArguments.add(this.appiumPort);
        appiumCommandLineArguments.add(AppiumArguments.SHOW_LOG_TIMESTAMPS.getCommandLineArgument());
        appiumCommandLineArguments.add(AppiumArguments.LOG_TO_FILE.getCommandLineArgument());
        appiumCommandLineArguments.add(new File(this.projectBuildDirectory, "appium.log").getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(appiumCommandLineArguments);
        processBuilder.redirectError(new File(this.projectBuildDirectory, "appiumServerErrors.log"));
        processBuilder.redirectOutput(new File(this.projectBuildDirectory, "appiumServerOutput.log"));
        try {
            PidProcess appiumProcess = Processes.newPidProcess((Process)processBuilder.start());
            if (!appiumProcess.isAlive()) {
                throw new MojoExecutionException("Unable to start Appium server!");
            }
            String processPID = Integer.toString(appiumProcess.getPid());
            FileUtils.writeStringToFile((File)new File(this.projectBuildDirectory, "appium.pid"), (String)processPID, (Charset)StandardCharsets.UTF_8);
            UtilityFunctions.waitForAppiumToStart(this.appiumStartupTicks, this.appiumIpAddress, this.appiumPort);
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("Unable to start Appium server!", ex);
        }
    }
}

