/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.ErrorStrategy;
import com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.eventsource.FaultEvent;
import com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.eventsource.ResponseHeaders;
import com.launchdarkly.eventsource.RetryDelayStrategy;
import com.launchdarkly.eventsource.SetRetryDelayEvent;
import com.launchdarkly.eventsource.StartedEvent;
import com.launchdarkly.eventsource.StreamClosedByCallerException;
import com.launchdarkly.eventsource.StreamEvent;
import com.launchdarkly.eventsource.StreamException;
import com.launchdarkly.eventsource.StreamHttpErrorException;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.HttpUrl;

public class EventSource
implements Closeable {
    private final LDLogger logger;
    public static final long DEFAULT_RETRY_DELAY_MILLIS = 1000L;
    public static final long DEFAULT_RETRY_DELAY_RESET_THRESHOLD_MILLIS = 60000L;
    public static final int DEFAULT_READ_BUFFER_SIZE = 1000;
    private final Object sleepNotifier = new Object();
    private final ConnectStrategy.Client client;
    final int readBufferSize;
    final ErrorStrategy baseErrorStrategy;
    final RetryDelayStrategy baseRetryDelayStrategy;
    final long retryDelayResetThresholdMillis;
    final boolean streamEventData;
    final Set<String> expectFields;
    private EventParser eventParser;
    ErrorStrategy currentErrorStrategy;
    RetryDelayStrategy currentRetryDelayStrategy;
    private long connectedTime;
    private long disconnectedTime;
    private StreamEvent nextEvent;
    private final AtomicReference<Closeable> connectionCloser = new AtomicReference();
    private final AtomicReference<Thread> readingThread = new AtomicReference();
    private final AtomicReference<ReadyState> readyState;
    private volatile boolean deliberatelyClosedConnection;
    private volatile boolean calledStop;
    volatile long baseRetryDelayMillis;
    private volatile String lastEventId;
    private volatile URI origin;
    private volatile long nextReconnectDelayMillis;

    EventSource(Builder builder) {
        this.logger = builder.logger == null ? LDLogger.none() : builder.logger;
        this.client = builder.connectStrategy.createClient(this.logger);
        this.origin = this.client.getOrigin();
        this.lastEventId = builder.lastEventId;
        this.currentErrorStrategy = builder.errorStrategy == null ? ErrorStrategy.alwaysThrow() : builder.errorStrategy;
        this.baseErrorStrategy = this.currentErrorStrategy;
        this.currentRetryDelayStrategy = builder.retryDelayStrategy == null ? RetryDelayStrategy.defaultStrategy() : builder.retryDelayStrategy;
        this.baseRetryDelayStrategy = this.currentRetryDelayStrategy;
        this.baseRetryDelayMillis = builder.retryDelayMillis;
        this.retryDelayResetThresholdMillis = builder.retryDelayResetThresholdMillis;
        this.streamEventData = builder.streamEventData;
        this.expectFields = builder.expectFields;
        this.readBufferSize = builder.readBufferSize;
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
    }

    public URI getOrigin() {
        return this.origin;
    }

    public LDLogger getLogger() {
        return this.logger;
    }

    public ReadyState getState() {
        return this.readyState.get();
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public long getBaseRetryDelayMillis() {
        return this.baseRetryDelayMillis;
    }

    public long getNextRetryDelayMillis() {
        return this.nextReconnectDelayMillis;
    }

    public void start() throws StreamException {
        this.tryStart(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FaultEvent tryStart(boolean canReturnFaultEvent) throws StreamException {
        ConnectStrategy.Client.Result clientResult;
        block16: {
            StreamException exception;
            block17: {
                if (this.eventParser != null) {
                    return null;
                }
                this.readingThread.set(Thread.currentThread());
                do {
                    exception = null;
                    if (this.nextReconnectDelayMillis > 0L) {
                        long delayNow;
                        long l = delayNow = this.disconnectedTime == 0L ? this.nextReconnectDelayMillis : this.nextReconnectDelayMillis - (System.currentTimeMillis() - this.disconnectedTime);
                        if (delayNow > 0L) {
                            this.logger.info("Waiting {} milliseconds before reconnecting", (Object)delayNow);
                            try {
                                Object object = this.sleepNotifier;
                                synchronized (object) {
                                    if (!this.deliberatelyClosedConnection) {
                                        this.sleepNotifier.wait(delayNow);
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                this.logger.debug((Object)"EventSource thread was interrupted during start()");
                                this.deliberatelyClosedConnection = true;
                                Thread.interrupted();
                            }
                            if (this.deliberatelyClosedConnection) {
                                exception = new StreamClosedByCallerException();
                            }
                        }
                    }
                    clientResult = null;
                    if (exception == null) {
                        this.readyState.set(ReadyState.CONNECTING);
                        this.connectedTime = 0L;
                        this.calledStop = false;
                        this.deliberatelyClosedConnection = false;
                        try {
                            clientResult = this.client.connect(this.lastEventId);
                        }
                        catch (StreamException e) {
                            exception = e;
                        }
                    }
                    if (exception == null) break block16;
                    this.disconnectedTime = System.currentTimeMillis();
                    this.computeReconnectDelay();
                    if (this.applyErrorStrategy(exception) != ErrorStrategy.Action.CONTINUE) break block17;
                } while (!canReturnFaultEvent);
                ResponseHeaders headers = null;
                if (exception instanceof StreamHttpErrorException) {
                    headers = ((StreamHttpErrorException)exception).getHeaders();
                }
                return new FaultEvent(exception, headers);
            }
            throw exception;
        }
        this.connectionCloser.set(clientResult.getCloser());
        this.origin = clientResult.getOrigin() == null ? this.client.getOrigin() : clientResult.getOrigin();
        this.connectedTime = System.currentTimeMillis();
        this.logger.debug((Object)"Connected to SSE stream");
        ResponseHeaders headers = clientResult.getHeaders();
        this.eventParser = new EventParser(clientResult.getInputStream(), clientResult.getOrigin(), this.readBufferSize, this.streamEventData, this.expectFields, this.logger, headers);
        this.readyState.set(ReadyState.OPEN);
        this.currentErrorStrategy = this.baseErrorStrategy;
        return null;
    }

    public MessageEvent readMessage() throws StreamException {
        StreamEvent event;
        while (!((event = this.readAnyEvent()) instanceof MessageEvent)) {
        }
        return (MessageEvent)event;
    }

    public StreamEvent readAnyEvent() throws StreamException {
        return this.requireEvent();
    }

    public Iterable<MessageEvent> messages() {
        return new Iterable<MessageEvent>(){

            @Override
            public Iterator<MessageEvent> iterator() {
                return new IteratorImpl<MessageEvent>(MessageEvent.class);
            }
        };
    }

    public Iterable<StreamEvent> anyEvents() {
        return new Iterable<StreamEvent>(){

            @Override
            public Iterator<StreamEvent> iterator() {
                return new IteratorImpl<StreamEvent>(StreamEvent.class);
            }
        };
    }

    public void interrupt() {
        this.closeCurrentStream(true, false);
    }

    public void stop() {
        this.closeCurrentStream(true, true);
    }

    @Override
    public void close() {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        this.closeCurrentStream(true, true);
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean awaitClosed(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.client.awaitClosed(Helpers.millisFromTimeUnit(timeout, timeUnit));
    }

    private StreamEvent requireEvent() throws StreamException {
        this.readingThread.set(Thread.currentThread());
        try {
            MessageEvent me;
            StreamEvent event;
            while (true) {
                if (this.eventParser == null) {
                    FaultEvent faultEvent = this.tryStart(true);
                    return faultEvent == null ? new StartedEvent() : faultEvent;
                }
                event = this.eventParser.nextEvent();
                if (!(event instanceof SetRetryDelayEvent)) break;
                this.baseRetryDelayMillis = ((SetRetryDelayEvent)event).getRetryMillis();
                this.resetRetryDelayStrategy();
            }
            if (event instanceof MessageEvent && (me = (MessageEvent)event).getLastEventId() != null) {
                this.lastEventId = me.getLastEventId();
            }
            return event;
        }
        catch (StreamException e2) {
            StreamClosedByCallerException e2;
            this.readyState.set(ReadyState.CLOSED);
            if (this.deliberatelyClosedConnection) {
                e2 = new StreamClosedByCallerException();
                this.deliberatelyClosedConnection = false;
            }
            this.disconnectedTime = System.currentTimeMillis();
            this.closeCurrentStream(false, false);
            this.eventParser = null;
            this.computeReconnectDelay();
            if (this.applyErrorStrategy(e2) == ErrorStrategy.Action.CONTINUE) {
                return new FaultEvent(e2, null);
            }
            throw e2;
        }
    }

    private void resetRetryDelayStrategy() {
        this.logger.debug((Object)"Resetting retry delay strategy to initial state");
        this.currentRetryDelayStrategy = this.baseRetryDelayStrategy;
    }

    private ErrorStrategy.Action applyErrorStrategy(StreamException e) {
        ErrorStrategy.Result errorStrategyResult = this.currentErrorStrategy.apply(e);
        if (errorStrategyResult.getNext() != null) {
            this.currentErrorStrategy = errorStrategyResult.getNext();
        }
        return errorStrategyResult.getAction();
    }

    private void computeReconnectDelay() {
        long connectionDurationMillis;
        if (this.retryDelayResetThresholdMillis > 0L && this.connectedTime != 0L && (connectionDurationMillis = System.currentTimeMillis() - this.connectedTime) >= this.retryDelayResetThresholdMillis) {
            this.resetRetryDelayStrategy();
        }
        RetryDelayStrategy.Result result = this.currentRetryDelayStrategy.apply(this.baseRetryDelayMillis);
        this.nextReconnectDelayMillis = result.getDelayMillis();
        if (result.getNext() != null) {
            this.currentRetryDelayStrategy = result.getNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeCurrentStream(boolean deliberatelyInterrupted, boolean shouldStopIterating) {
        Closeable oldConnectionCloser = this.connectionCloser.getAndSet(null);
        Thread oldReadingThread = this.readingThread.getAndSet(null);
        if (oldConnectionCloser == null && oldReadingThread == null) {
            return false;
        }
        Object object = this.sleepNotifier;
        synchronized (object) {
            if (deliberatelyInterrupted) {
                this.deliberatelyClosedConnection = true;
            }
            if (shouldStopIterating) {
                this.calledStop = true;
            }
            if (oldConnectionCloser != null) {
                try {
                    oldConnectionCloser.close();
                    this.logger.debug((Object)"Closed request");
                }
                catch (IOException e) {
                    this.logger.warn("Unexpected error when closing connection: {}", LogValues.exceptionSummary((Throwable)e));
                }
            }
            if (oldReadingThread == Thread.currentThread()) {
                this.eventParser = null;
                this.readyState.compareAndSet(ReadyState.OPEN, ReadyState.CLOSED);
                this.readyState.compareAndSet(ReadyState.CONNECTING, ReadyState.CLOSED);
            }
            this.sleepNotifier.notify();
        }
        return true;
    }

    public static final class Builder {
        private final ConnectStrategy connectStrategy;
        private ErrorStrategy errorStrategy;
        private RetryDelayStrategy retryDelayStrategy;
        private long retryDelayMillis = 1000L;
        private long retryDelayResetThresholdMillis = 60000L;
        private String lastEventId;
        private int readBufferSize = 1000;
        private LDLogger logger = null;
        private boolean streamEventData;
        private Set<String> expectFields = null;

        public Builder(ConnectStrategy connectStrategy) {
            if (connectStrategy == null) {
                throw new IllegalArgumentException("connectStrategy must not be null");
            }
            this.connectStrategy = connectStrategy;
        }

        public Builder(URI uri) {
            this(ConnectStrategy.http(uri));
        }

        public Builder(URL url) {
            this(ConnectStrategy.http(url));
        }

        public Builder(HttpUrl url) {
            this(ConnectStrategy.http(url));
        }

        public Builder errorStrategy(ErrorStrategy errorStrategy) {
            this.errorStrategy = errorStrategy;
            return this;
        }

        public Builder lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        public Builder retryDelay(long retryDelay, TimeUnit timeUnit) {
            this.retryDelayMillis = Helpers.millisFromTimeUnit(retryDelay, timeUnit);
            return this;
        }

        public Builder retryDelayStrategy(RetryDelayStrategy retryDelayStrategy) {
            this.retryDelayStrategy = retryDelayStrategy;
            return this;
        }

        public Builder retryDelayResetThreshold(long retryDelayResetThreshold, TimeUnit timeUnit) {
            this.retryDelayResetThresholdMillis = Helpers.millisFromTimeUnit(retryDelayResetThreshold, timeUnit);
            return this;
        }

        public Builder readBufferSize(int readBufferSize) {
            if (readBufferSize <= 0) {
                throw new IllegalArgumentException("readBufferSize must be greater than zero");
            }
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder logger(LDLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder streamEventData(boolean streamEventData) {
            this.streamEventData = streamEventData;
            return this;
        }

        public Builder expectFields(String ... fieldNames) {
            if (fieldNames == null || fieldNames.length == 0) {
                this.expectFields = null;
            } else {
                this.expectFields = new HashSet<String>();
                for (String f : fieldNames) {
                    if (f == null) continue;
                    this.expectFields.add(f);
                }
            }
            return this;
        }

        public EventSource build() {
            return new EventSource(this);
        }
    }

    private class IteratorImpl<T extends StreamEvent>
    implements Iterator<T> {
        private final Class<T> filterClass;

        IteratorImpl(Class<T> filterClass) {
            this.filterClass = filterClass;
            EventSource.this.calledStop = false;
        }

        @Override
        public boolean hasNext() {
            while (EventSource.this.nextEvent == null || !this.filterClass.isAssignableFrom(EventSource.this.nextEvent.getClass())) {
                if (EventSource.this.calledStop) {
                    EventSource.this.calledStop = false;
                    return false;
                }
                try {
                    EventSource.this.nextEvent = EventSource.this.requireEvent();
                }
                catch (StreamException e) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public T next() {
            while (EventSource.this.nextEvent == null || !this.filterClass.isAssignableFrom(EventSource.this.nextEvent.getClass()) && this.hasNext()) {
            }
            StreamEvent event = EventSource.this.nextEvent;
            EventSource.this.nextEvent = null;
            return (T)event;
        }
    }
}

