/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.MessageEvent;
import java.util.concurrent.Executor;

class AsyncEventHandler
implements EventHandler {
    private final Executor executor;
    private final EventHandler eventSourceHandler;

    AsyncEventHandler(Executor executor, EventHandler eventSourceHandler) {
        this.executor = executor;
        this.eventSourceHandler = eventSourceHandler;
    }

    @Override
    public void onOpen() {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onOpen();
            }
            catch (Exception e) {
                this.onError(e);
            }
        });
    }

    @Override
    public void onClosed() {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onClosed();
            }
            catch (Exception e) {
                this.onError(e);
            }
        });
    }

    @Override
    public void onComment(String comment) {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onComment(comment);
            }
            catch (Exception e) {
                this.onError(e);
            }
        });
    }

    @Override
    public void onMessage(String event, MessageEvent messageEvent) {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onMessage(event, messageEvent);
            }
            catch (Exception e) {
                this.onError(e);
            }
        });
    }

    @Override
    public void onError(Throwable error) {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onError(error);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }
}

