/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.eventsource.ConnectionErrorHandler;
import com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.eventsource.ModernTLSSocketFactory;
import com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.eventsource.UnsuccessfulResponseException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSource
implements ConnectionHandler,
Closeable {
    private final Logger logger;
    private static final long DEFAULT_RECONNECT_TIME_MS = 1000L;
    static final long MAX_RECONNECT_TIME_MS = 30000L;
    static final int DEFAULT_CONNECT_TIMEOUT_MS = 10000;
    static final int DEFAULT_WRITE_TIMEOUT_MS = 5000;
    static final int DEFAULT_READ_TIMEOUT_MS = 300000;
    private final String name;
    private volatile URI uri;
    private final Headers headers;
    private final String method;
    @Nullable
    private final RequestBody body;
    private final ExecutorService eventExecutor;
    private final ExecutorService streamExecutor;
    private volatile long reconnectTimeMs = 0L;
    private volatile String lastEventId;
    private final EventHandler handler;
    private final ConnectionErrorHandler connectionErrorHandler;
    private final AtomicReference<ReadyState> readyState;
    private final OkHttpClient client;
    private volatile Call call;
    private final Random jitter = new Random();
    private Response response;
    private BufferedSource bufferedSource;

    EventSource(Builder builder) {
        this.name = builder.name;
        this.logger = LoggerFactory.getLogger((String)(EventSource.class.getCanonicalName() + "." + this.name));
        this.uri = builder.uri;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.method = builder.method;
        this.body = builder.body;
        this.reconnectTimeMs = builder.reconnectTimeMs;
        ThreadFactory eventsThreadFactory = this.createThreadFactory("okhttp-eventsource-events");
        this.eventExecutor = Executors.newSingleThreadExecutor(eventsThreadFactory);
        ThreadFactory streamThreadFactory = this.createThreadFactory("okhttp-eventsource-stream");
        this.streamExecutor = Executors.newSingleThreadExecutor(streamThreadFactory);
        this.handler = new AsyncEventHandler(this.eventExecutor, builder.handler);
        this.connectionErrorHandler = builder.connectionErrorHandler;
        this.readyState = new AtomicReference<ReadyState>(ReadyState.RAW);
        this.client = builder.clientBuilder.build();
    }

    private ThreadFactory createThreadFactory(final String type) {
        final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        final AtomicLong count = new AtomicLong(0L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                thread.setName(String.format(Locale.ROOT, "%s-[%s]-%d", type, EventSource.this.name, count.getAndIncrement()));
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public void start() {
        if (!this.readyState.compareAndSet(ReadyState.RAW, ReadyState.CONNECTING)) {
            this.logger.info("Start method called on this already-started EventSource object. Doing nothing");
            return;
        }
        this.logger.debug("readyState change: " + (Object)((Object)ReadyState.RAW) + " -> " + (Object)((Object)ReadyState.CONNECTING));
        this.logger.info("Starting EventSource client using URI: " + this.uri);
        this.streamExecutor.execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.connect();
            }
        });
    }

    public ReadyState getState() {
        return this.readyState.get();
    }

    @Override
    public void close() {
        ReadyState currentState = this.readyState.getAndSet(ReadyState.SHUTDOWN);
        this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.SHUTDOWN));
        if (currentState == ReadyState.SHUTDOWN) {
            return;
        }
        if (currentState == ReadyState.OPEN) {
            try {
                this.handler.onClosed();
            }
            catch (Exception e) {
                this.handler.onError(e);
            }
        }
        if (this.call != null) {
            this.call.cancel();
            this.logger.debug("call cancelled");
        }
        this.eventExecutor.shutdownNow();
        this.streamExecutor.shutdownNow();
        if (this.client != null) {
            if (this.client.connectionPool() != null) {
                this.client.connectionPool().evictAll();
            }
            if (this.client.dispatcher() != null) {
                this.client.dispatcher().cancelAll();
                if (this.client.dispatcher().executorService() != null) {
                    this.client.dispatcher().executorService().shutdownNow();
                }
            }
        }
    }

    Request buildRequest() {
        Request.Builder builder = new Request.Builder().headers(this.headers).url(this.uri.toASCIIString()).method(this.method, this.body);
        if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
            builder.addHeader("Last-Event-ID", this.lastEventId);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void connect() {
        this.response = null;
        this.bufferedSource = null;
        int reconnectAttempts = 0;
        ConnectionErrorHandler.Action errorHandlerAction = null;
        try {
            block27: while (!Thread.currentThread().isInterrupted()) {
                if (this.readyState.get() == ReadyState.SHUTDOWN) return;
                boolean gotResponse = false;
                boolean timedOut = false;
                this.maybeWaitWithBackoff(reconnectAttempts++);
                ReadyState currentState = this.readyState.getAndSet(ReadyState.CONNECTING);
                this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.CONNECTING));
                try {
                    this.call = this.client.newCall(this.buildRequest());
                    this.response = this.call.execute();
                    if (this.response.isSuccessful()) {
                        gotResponse = true;
                        currentState = this.readyState.getAndSet(ReadyState.OPEN);
                        if (currentState != ReadyState.CONNECTING) {
                            this.logger.warn("Unexpected readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        } else {
                            this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)ReadyState.OPEN));
                        }
                        this.logger.info("Connected to Event Source stream.");
                        try {
                            this.handler.onOpen();
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                        if (this.bufferedSource != null) {
                            this.bufferedSource.close();
                        }
                        this.bufferedSource = Okio.buffer((Source)this.response.body().source());
                        EventParser parser = new EventParser(this.uri, this.handler, this);
                        while (true) {
                            String line;
                            if (Thread.currentThread().isInterrupted() || (line = this.bufferedSource.readUtf8LineStrict()) == null) continue block27;
                            parser.line(line);
                        }
                    }
                    this.logger.debug("Unsuccessful Response: " + this.response);
                    errorHandlerAction = this.dispatchError(new UnsuccessfulResponseException(this.response.code()));
                }
                catch (EOFException eofe) {
                    this.logger.warn("Connection unexpectedly closed.");
                }
                catch (IOException ioe) {
                    if (this.readyState.get() != ReadyState.SHUTDOWN) {
                        this.logger.debug("Connection problem.", (Throwable)ioe);
                        errorHandlerAction = this.dispatchError(ioe);
                    } else {
                        errorHandlerAction = ConnectionErrorHandler.Action.SHUTDOWN;
                    }
                    if (!(ioe instanceof SocketTimeoutException)) continue;
                    timedOut = true;
                }
                finally {
                    ReadyState nextState = ReadyState.CLOSED;
                    if (errorHandlerAction == ConnectionErrorHandler.Action.SHUTDOWN) {
                        this.logger.info("Connection has been explicitly shut down by error handler");
                        nextState = ReadyState.SHUTDOWN;
                    }
                    currentState = this.readyState.getAndSet(nextState);
                    this.logger.debug("readyState change: " + (Object)((Object)currentState) + " -> " + (Object)((Object)nextState));
                    if (this.response != null && this.response.body() != null) {
                        this.response.close();
                        this.logger.debug("response closed");
                    }
                    if (this.bufferedSource != null) {
                        try {
                            this.bufferedSource.close();
                            this.logger.debug("buffered source closed");
                        }
                        catch (IOException e) {
                            this.logger.warn("Exception when closing bufferedSource", (Throwable)e);
                        }
                    }
                    if (currentState == ReadyState.OPEN) {
                        try {
                            this.handler.onClosed();
                        }
                        catch (Exception e) {
                            this.handler.onError(e);
                        }
                    }
                    if (!gotResponse || timedOut) continue;
                    reconnectAttempts = 0;
                }
            }
            return;
        }
        catch (RejectedExecutionException ignored) {
            this.call = null;
            this.response = null;
            this.bufferedSource = null;
            this.logger.debug("Rejected execution exception ignored: ", (Throwable)ignored);
        }
    }

    private ConnectionErrorHandler.Action dispatchError(Throwable t) {
        ConnectionErrorHandler.Action action = this.connectionErrorHandler.onConnectionError(t);
        if (action != ConnectionErrorHandler.Action.SHUTDOWN) {
            this.handler.onError(t);
        }
        return action;
    }

    private void maybeWaitWithBackoff(int reconnectAttempts) {
        if (this.reconnectTimeMs > 0L && reconnectAttempts > 0) {
            try {
                long sleepTimeMs = this.backoffWithJitter(reconnectAttempts);
                this.logger.info("Waiting " + sleepTimeMs + " milliseconds before reconnecting...");
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    long backoffWithJitter(int reconnectAttempts) {
        long jitterVal = Math.min(30000L, this.reconnectTimeMs * (long)this.pow2(reconnectAttempts));
        return jitterVal / 2L + this.nextLong(this.jitter, jitterVal) / 2L;
    }

    private int pow2(int k) {
        return k < 31 ? 1 << k : Integer.MAX_VALUE;
    }

    private long nextLong(Random rand, long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = rand.nextLong() & Long.MAX_VALUE;
        long m = bound - 1L;
        if ((bound & m) == 0L) {
            r = bound * r >> 63;
        } else {
            long u = r;
            while (u - (r = u % bound) + m < 0L) {
                u = rand.nextLong() & Long.MAX_VALUE;
            }
        }
        return r;
    }

    private static Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        builder.add("Accept", "text/event-stream").add("Cache-Control", "no-cache");
        for (Map.Entry header : custom.toMultimap().entrySet()) {
            for (String value : (List)header.getValue()) {
                builder.add((String)header.getKey(), value);
            }
        }
        return builder.build();
    }

    @Override
    public void setReconnectionTimeMs(long reconnectionTimeMs) {
        this.reconnectTimeMs = reconnectionTimeMs;
    }

    @Override
    public void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public static final class Builder {
        private String name = "";
        private long reconnectTimeMs = 1000L;
        private final URI uri;
        private final EventHandler handler;
        private ConnectionErrorHandler connectionErrorHandler = ConnectionErrorHandler.DEFAULT;
        private Headers headers = Headers.of((String[])new String[0]);
        private Proxy proxy;
        private Authenticator proxyAuthenticator = null;
        private String method = "GET";
        @Nullable
        private RequestBody body = null;
        private OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 1L, TimeUnit.SECONDS)).connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(300000L, TimeUnit.MILLISECONDS).writeTimeout(5000L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);

        public Builder(EventHandler handler, URI uri) {
            this.uri = uri;
            this.handler = handler;
        }

        public Builder method(String method) {
            if (method != null && method.length() > 0) {
                this.method = method.toUpperCase();
            }
            return this;
        }

        public Builder body(@Nullable RequestBody body) {
            this.body = body;
            return this;
        }

        public Builder name(String name) {
            if (name != null) {
                this.name = name;
            }
            return this;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMs = reconnectTimeMs;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.clientBuilder = client.newBuilder();
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this;
        }

        public Builder connectTimeoutMs(int connectTimeoutMs) {
            this.clientBuilder.connectTimeout((long)connectTimeoutMs, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder writeTimeoutMs(int writeTimeoutMs) {
            this.clientBuilder.writeTimeout((long)writeTimeoutMs, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder readTimeoutMs(int readTimeoutMs) {
            this.clientBuilder.readTimeout((long)readTimeoutMs, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder connectionErrorHandler(ConnectionErrorHandler handler) {
            if (handler != null) {
                this.connectionErrorHandler = handler;
            }
            return this;
        }

        public EventSource build() {
            if (this.proxy != null) {
                this.clientBuilder.proxy(this.proxy);
            }
            try {
                this.clientBuilder.sslSocketFactory((SSLSocketFactory)new ModernTLSSocketFactory(), Builder.defaultTrustManager());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (this.proxyAuthenticator != null) {
                this.clientBuilder.proxyAuthenticator(this.proxyAuthenticator);
            }
            return new EventSource(this);
        }

        protected OkHttpClient.Builder getClientBuilder() {
            return this.clientBuilder;
        }

        private static X509TrustManager defaultTrustManager() throws GeneralSecurityException {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
    }
}

