/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.AsyncEventHandler;
import com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventParser;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.UnsuccessfulResponseException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class EventSource
implements ConnectionHandler {
    public static final long DEFAULT_RECONNECT_TIME_MS = 1000L;
    public static final int CONNECTING = 0;
    public static final int OPEN = 1;
    public static final int CLOSED = 2;
    private final URI uri;
    private final Headers headers;
    private final ExecutorService executor;
    private volatile long reconnectTimeMs;
    private volatile String lastEventId;
    private final EventHandler handler;
    private AtomicInteger readyState;
    private final OkHttpClient client;

    EventSource(Builder builder) {
        this.uri = builder.uri;
        this.headers = EventSource.addDefaultHeaders(builder.headers);
        this.reconnectTimeMs = builder.reconnectTimeMs;
        this.executor = Executors.newCachedThreadPool();
        this.handler = new AsyncEventHandler(this.executor, builder.handler);
        this.readyState = new AtomicInteger(2);
        this.client = builder.client.newBuilder().readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    public void start() {
        if (!this.readyState.compareAndSet(2, 0)) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventSource.this.connect();
            }
        });
    }

    public void stop() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        block14: {
            Request.Builder builder = new Request.Builder().headers(this.headers).url(this.uri.toASCIIString()).get();
            if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                builder.addHeader("Last-Event-ID", this.lastEventId);
            }
            Response response = null;
            try {
                response = this.client.newCall(builder.build()).execute();
                if (response.isSuccessful()) {
                    String line;
                    this.readyState.compareAndSet(0, 1);
                    BufferedSource bs = Okio.buffer((Source)response.body().source());
                    EventParser parser = new EventParser(this.uri, this.handler, this);
                    while (!Thread.currentThread().isInterrupted() && (line = bs.readUtf8LineStrict()) != null) {
                        parser.line(line);
                    }
                    break block14;
                }
                this.readyState.set(2);
                try {
                    this.handler.onError(new UnsuccessfulResponseException(response.code()));
                    this.reconnect();
                }
                catch (RejectedExecutionException bs) {
                    // empty catch block
                }
            }
            catch (RejectedExecutionException bs) {
            }
            catch (Exception e) {
                this.readyState.set(2);
                try {
                    this.handler.onError(e);
                    this.reconnect();
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            finally {
                if (response != null && response.body() != null) {
                    response.body().close();
                }
            }
        }
    }

    public void reconnect() {
        try {
            Thread.sleep(this.reconnectTimeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.readyState.compareAndSet(2, 0)) {
            return;
        }
        this.connect();
    }

    private static final Headers addDefaultHeaders(Headers custom) {
        Headers.Builder builder = new Headers.Builder();
        builder.add("Accept", "text/event-stream").add("Cache-Control", "no-cache");
        for (Map.Entry header : custom.toMultimap().entrySet()) {
            for (String value : (List)header.getValue()) {
                builder.add((String)header.getKey(), value);
            }
        }
        return builder.build();
    }

    @Override
    public void setReconnectionTimeMs(long reconnectionTimeMs) {
        this.reconnectTimeMs = reconnectionTimeMs;
    }

    @Override
    public void setLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    public static void main(String ... args) {
        EventHandler handler = new EventHandler(){

            @Override
            public void onOpen() throws Exception {
                System.out.println("Open");
            }

            @Override
            public void onMessage(String event, MessageEvent messageEvent) throws Exception {
                System.out.println(event + ": " + messageEvent.getData());
            }

            @Override
            public void onError(Throwable t) {
                System.out.println("Error: " + t);
            }
        };
        EventSource source = new Builder(handler, URI.create("http://localhost:8080/events/")).build();
        source.start();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Stopping source");
        source.stop();
        System.out.println("Stopped");
    }

    public static final class Builder {
        private long reconnectTimeMs = 1000L;
        private final URI uri;
        private final EventHandler handler;
        private Headers headers = Headers.of((String[])new String[0]);
        private OkHttpClient client = new OkHttpClient();

        public Builder(EventHandler handler, URI uri) {
            this.uri = uri;
            this.handler = handler;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMs = reconnectTimeMs;
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public EventSource build() {
            return new EventSource(this);
        }
    }
}

