/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.AttributeRefTypeAdapter;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import java.util.HashMap;
import java.util.Map;

@JsonAdapter(value=AttributeRefTypeAdapter.class)
public final class AttributeRef
implements JsonSerializable,
Comparable<AttributeRef> {
    private static final Map<String, AttributeRef> COMMON_LITERALS = AttributeRef.makeLiteralsMap("kind", "key", "name", "anonymous", "email", "firstName", "lastName", "country", "ip", "avatar");
    private final String error;
    private final String rawPath;
    private final String singlePathComponent;
    private final String[] components;

    private AttributeRef(String rawPath, String singlePathComponent, String[] components) {
        this.error = null;
        this.rawPath = rawPath == null ? "" : rawPath;
        this.singlePathComponent = singlePathComponent;
        this.components = components;
    }

    private AttributeRef(String error, String rawPath) {
        this.error = error;
        this.rawPath = rawPath == null ? "" : rawPath;
        this.singlePathComponent = null;
        this.components = null;
    }

    public static AttributeRef fromPath(String refPath) {
        if (refPath == null || refPath.isEmpty() || refPath.equals("/")) {
            return new AttributeRef("attribute reference cannot be empty", refPath);
        }
        if (refPath.charAt(0) != '/') {
            return new AttributeRef(refPath, refPath, null);
        }
        if (refPath.indexOf(47, 1) < 0) {
            String unescaped = AttributeRef.unescapePath(refPath.substring(1));
            if (unescaped == null) {
                return new AttributeRef("attribute reference contained an escape character (~) that was not followed by 0 or 1", refPath);
            }
            return new AttributeRef(refPath, unescaped, null);
        }
        if (refPath.endsWith("/")) {
            return new AttributeRef("attribute reference contained a double slash or a trailing slash", refPath);
        }
        String[] parsed = refPath.substring(1).split("/");
        for (int i = 0; i < parsed.length; ++i) {
            String p = parsed[i];
            if (p.isEmpty()) {
                return new AttributeRef("attribute reference contained a double slash or a trailing slash", refPath);
            }
            String unescaped = AttributeRef.unescapePath(p);
            if (unescaped == null) {
                return new AttributeRef("attribute reference contained an escape character (~) that was not followed by 0 or 1", refPath);
            }
            parsed[i] = unescaped;
        }
        return new AttributeRef(refPath, null, parsed);
    }

    public static AttributeRef fromLiteral(String attributeName) {
        if (attributeName == null || attributeName.isEmpty()) {
            return new AttributeRef("attribute reference cannot be empty", "");
        }
        if (attributeName.charAt(0) != '/') {
            AttributeRef internedInstance = COMMON_LITERALS.get(attributeName);
            return internedInstance == null ? new AttributeRef(attributeName, attributeName, null) : internedInstance;
        }
        String escapedPath = "/" + attributeName.replace("~", "~0").replace("/", "~1");
        return new AttributeRef(escapedPath, attributeName, null);
    }

    public boolean isValid() {
        return this.error == null;
    }

    public String getError() {
        return this.error;
    }

    public int getDepth() {
        if (this.error != null) {
            return 0;
        }
        return this.components == null ? 1 : this.components.length;
    }

    public String getComponent(int index) {
        if (this.components == null) {
            return index == 0 ? this.singlePathComponent : null;
        }
        return index < 0 || index >= this.components.length ? null : this.components[index];
    }

    public String toString() {
        return this.rawPath;
    }

    public boolean equals(Object other) {
        if (other instanceof AttributeRef) {
            AttributeRef o = (AttributeRef)other;
            return this.rawPath.equals(o.rawPath);
        }
        return false;
    }

    public int hashCode() {
        return this.rawPath.hashCode();
    }

    @Override
    public int compareTo(AttributeRef o) {
        return this.rawPath.compareTo(o.rawPath);
    }

    private static String unescapePath(String path) {
        if (path.indexOf(126) < 0) {
            return path;
        }
        StringBuilder ret = new StringBuilder(100);
        block4: for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (ch != '~') {
                ret.append(ch);
                continue;
            }
            if (++i >= path.length()) {
                return null;
            }
            switch (path.charAt(i)) {
                case '0': {
                    ret.append('~');
                    continue block4;
                }
                case '1': {
                    ret.append('/');
                    continue block4;
                }
                default: {
                    return null;
                }
            }
        }
        return ret.toString();
    }

    private static Map<String, AttributeRef> makeLiteralsMap(String ... names) {
        HashMap<String, AttributeRef> ret = new HashMap<String, AttributeRef>();
        for (String name : names) {
            ret.put(name, new AttributeRef(name, name, null));
        }
        return ret;
    }
}

