/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.GsonHelpers;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

class EventContextFormatter {
    private final boolean allAttributesPrivate;
    private final AttributeRef[] globalPrivateAttributes;

    EventContextFormatter(boolean allAttributesPrivate, AttributeRef[] globalPrivateAttributes) {
        this.allAttributesPrivate = allAttributesPrivate;
        this.globalPrivateAttributes = globalPrivateAttributes == null ? new AttributeRef[]{} : globalPrivateAttributes;
    }

    public void write(LDContext c, JsonWriter w, boolean redactAnonymous) throws IOException {
        if (c.isMultiple()) {
            w.beginObject();
            w.name("kind").value("multi");
            for (int i = 0; i < c.getIndividualContextCount(); ++i) {
                LDContext c1 = c.getIndividualContext(i);
                w.name(c1.getKind().toString());
                this.writeSingleKind(c1, w, false, redactAnonymous);
            }
            w.endObject();
        } else {
            this.writeSingleKind(c, w, true, redactAnonymous);
        }
    }

    private void writeSingleKind(LDContext c, JsonWriter w, boolean includeKind, boolean redactAnonymous) throws IOException {
        boolean haveRedacted;
        w.beginObject();
        if (includeKind) {
            w.name("kind").value(c.getKind().toString());
        }
        w.name("key").value(c.getKey());
        if (c.isAnonymous()) {
            w.name("anonymous").value(true);
        }
        List<String> redacted = null;
        if (c.getName() != null) {
            if (this.isAttributeEntirelyPrivate(c, "name", redactAnonymous)) {
                redacted = EventContextFormatter.addOrCreate(redacted, "name");
            } else {
                w.name("name").value(c.getName());
            }
        }
        for (String attrName : c.getCustomAttributeNames()) {
            redacted = this.writeOrRedactAttribute(w, c, attrName, c.getValue(attrName), redacted, redactAnonymous);
        }
        boolean bl = haveRedacted = redacted != null && !redacted.isEmpty();
        if (haveRedacted) {
            w.name("_meta").beginObject();
            w.name("redactedAttributes").beginArray();
            for (String a : redacted) {
                w.value(a);
            }
            w.endArray();
            w.endObject();
        }
        w.endObject();
    }

    private boolean isAttributeEntirelyPrivate(LDContext c, String attrName, boolean redactAnonymous) {
        if (this.allAttributesPrivate) {
            return true;
        }
        if (redactAnonymous && c.isAnonymous()) {
            return true;
        }
        AttributeRef privateRef = this.findPrivateRef(c, 1, attrName, null);
        return privateRef != null && privateRef.getDepth() == 1;
    }

    private List<String> writeOrRedactAttribute(JsonWriter w, LDContext c, String attrName, LDValue value, List<String> redacted, boolean redactAnonymous) throws IOException {
        if (this.allAttributesPrivate) {
            return EventContextFormatter.addOrCreate(redacted, attrName);
        }
        if (redactAnonymous && c.isAnonymous()) {
            return EventContextFormatter.addOrCreate(redacted, attrName);
        }
        return this.writeRedactedValue(w, c, 0, attrName, value, null, redacted);
    }

    private List<String> writeRedactedValue(JsonWriter w, LDContext c, int previousDepth, String attrName, LDValue value, AttributeRef previousMatchRef, List<String> redacted) throws IOException {
        int depth = previousDepth + 1;
        AttributeRef privateRef = this.findPrivateRef(c, depth, attrName, previousMatchRef);
        if (privateRef != null && privateRef.getDepth() == depth) {
            return EventContextFormatter.addOrCreate(redacted, privateRef.toString());
        }
        if (privateRef == null || value.getType() != LDValueType.OBJECT) {
            EventContextFormatter.writeNameAndValue(w, attrName, value);
            return redacted;
        }
        w.name(attrName).beginObject();
        for (String name : value.keys()) {
            redacted = this.writeRedactedValue(w, c, depth, name, value.get(name), privateRef, redacted);
        }
        w.endObject();
        return redacted;
    }

    private AttributeRef findPrivateRef(LDContext c, int depth, String attrName, AttributeRef previousMatchRef) {
        AttributeRef nonExactMatch = null;
        if (this.globalPrivateAttributes.length != 0) {
            for (AttributeRef globalPrivate : this.globalPrivateAttributes) {
                if (!EventContextFormatter.matchPrivateRef(globalPrivate, depth, attrName, previousMatchRef)) continue;
                if (globalPrivate.getDepth() == depth) {
                    return globalPrivate;
                }
                nonExactMatch = globalPrivate;
            }
        }
        for (int i = 0; i < c.getPrivateAttributeCount(); ++i) {
            AttributeRef contextPrivate = c.getPrivateAttribute(i);
            if (!EventContextFormatter.matchPrivateRef(contextPrivate, depth, attrName, previousMatchRef)) continue;
            if (contextPrivate.getDepth() == depth) {
                return contextPrivate;
            }
            nonExactMatch = contextPrivate;
        }
        return nonExactMatch;
    }

    private static boolean matchPrivateRef(AttributeRef ref, int depth, String attrName, AttributeRef previousMatchRef) {
        if (ref.getDepth() < depth) {
            return false;
        }
        for (int i = 0; i < depth - 1; ++i) {
            if (ref.getComponent(i).equals(previousMatchRef.getComponent(i))) continue;
            return false;
        }
        return ref.getComponent(depth - 1).equals(attrName);
    }

    private static void writeNameAndValue(JsonWriter w, String name, LDValue value) throws IOException {
        w.name(name);
        GsonHelpers.gsonInstance().toJson((Object)value, (Type)((Object)LDValue.class), w);
    }

    private static <T> List<T> addOrCreate(List<T> list, T value) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(value);
        return list;
    }
}

