/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations.reactor;

import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.LDClient;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.integrations.reactor.LDReactorClientInterface;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagTracker;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public final class LDReactorClient
implements LDReactorClientInterface {
    private final LDClient wrappedClient;
    private final Scheduler scheduler;

    public LDReactorClient(String sdkKey, Scheduler scheduler) {
        this.wrappedClient = new LDClient(sdkKey);
        this.scheduler = scheduler;
    }

    public LDReactorClient(String sdkKey, LDConfig config, Scheduler scheduler) {
        this.wrappedClient = new LDClient(sdkKey, config);
        this.scheduler = scheduler;
    }

    @Override
    public boolean isInitialized() {
        return this.wrappedClient.isInitialized();
    }

    @Override
    public void track(String eventName, LDContext context) {
        this.wrappedClient.track(eventName, context);
    }

    @Override
    public void trackData(String eventName, LDContext context, LDValue data) {
        this.wrappedClient.trackData(eventName, context, data);
    }

    @Override
    public void trackMetric(String eventName, LDContext context, LDValue data, double metricValue) {
        this.wrappedClient.trackMetric(eventName, context, data, metricValue);
    }

    @Override
    public void identify(LDContext context) {
        this.wrappedClient.identify(context);
    }

    @Override
    public Mono<FeatureFlagsState> allFlagsState(LDContext context, FlagsStateOption ... options) {
        return Mono.fromCallable(() -> this.wrappedClient.allFlagsState(context, options)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<Boolean> boolVariation(String featureKey, LDContext context, boolean defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.boolVariation(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<Integer> intVariation(String featureKey, LDContext context, int defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.intVariation(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<Double> doubleVariation(String featureKey, LDContext context, double defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.doubleVariation(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<String> stringVariation(String featureKey, LDContext context, String defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.stringVariation(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<LDValue> jsonValueVariation(String featureKey, LDContext context, LDValue defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.jsonValueVariation(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<EvaluationDetail<Boolean>> boolVariationDetail(String featureKey, LDContext context, boolean defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.boolVariationDetail(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<EvaluationDetail<Integer>> intVariationDetail(String featureKey, LDContext context, int defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.intVariationDetail(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<EvaluationDetail<Double>> doubleVariationDetail(String featureKey, LDContext context, double defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.doubleVariationDetail(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<EvaluationDetail<String>> stringVariationDetail(String featureKey, LDContext context, String defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.stringVariationDetail(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public Mono<EvaluationDetail<LDValue>> jsonValueVariationDetail(String featureKey, LDContext context, LDValue defaultValue) {
        return Mono.fromCallable(() -> this.wrappedClient.jsonValueVariationDetail(featureKey, context, defaultValue)).subscribeOn(this.scheduler);
    }

    @Override
    public boolean isFlagKnown(String featureKey) {
        return this.wrappedClient.isFlagKnown(featureKey);
    }

    @Override
    public FlagTracker getFlagTracker() {
        return this.wrappedClient.getFlagTracker();
    }

    @Override
    public BigSegmentStoreStatusProvider getBigSegmentStoreStatusProvider() {
        return this.wrappedClient.getBigSegmentStoreStatusProvider();
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.wrappedClient.getDataStoreStatusProvider();
    }

    @Override
    public DataSourceStatusProvider getDataSourceStatusProvider() {
        return this.wrappedClient.getDataSourceStatusProvider();
    }

    @Override
    public Mono<Void> close() {
        return Mono.fromCallable(() -> {
            this.wrappedClient.close();
            return null;
        }).subscribeOn(this.scheduler);
    }

    @Override
    public void flush() {
        this.wrappedClient.flush();
    }

    @Override
    public boolean isOffline() {
        return this.wrappedClient.isOffline();
    }

    @Override
    public String secureModeHash(LDContext context) {
        return this.wrappedClient.secureModeHash(context);
    }

    @Override
    public String version() {
        return this.wrappedClient.version();
    }
}

