/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import java.time.Duration;

public final class BigSegmentsConfigurationBuilder
implements ComponentConfigurer<BigSegmentsConfiguration> {
    public static final int DEFAULT_USER_CACHE_SIZE = 1000;
    public static final Duration DEFAULT_USER_CACHE_TIME = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_STATUS_POLL_INTERVAL = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_STALE_AFTER = Duration.ofMinutes(2L);
    private final ComponentConfigurer<BigSegmentStore> storeConfigurer;
    private int userCacheSize = 1000;
    private Duration userCacheTime = DEFAULT_USER_CACHE_TIME;
    private Duration statusPollInterval = DEFAULT_STATUS_POLL_INTERVAL;
    private Duration staleAfter = DEFAULT_STALE_AFTER;

    public BigSegmentsConfigurationBuilder(ComponentConfigurer<BigSegmentStore> storeConfigurer) {
        this.storeConfigurer = storeConfigurer;
    }

    public BigSegmentsConfigurationBuilder userCacheSize(int userCacheSize) {
        this.userCacheSize = Math.max(userCacheSize, 0);
        return this;
    }

    public BigSegmentsConfigurationBuilder userCacheTime(Duration userCacheTime) {
        this.userCacheTime = userCacheTime != null && userCacheTime.compareTo(Duration.ZERO) >= 0 ? userCacheTime : DEFAULT_USER_CACHE_TIME;
        return this;
    }

    public BigSegmentsConfigurationBuilder statusPollInterval(Duration statusPollInterval) {
        this.statusPollInterval = statusPollInterval != null && statusPollInterval.compareTo(Duration.ZERO) > 0 ? statusPollInterval : DEFAULT_STATUS_POLL_INTERVAL;
        return this;
    }

    public BigSegmentsConfigurationBuilder staleAfter(Duration staleAfter) {
        this.staleAfter = staleAfter != null && staleAfter.compareTo(Duration.ZERO) > 0 ? staleAfter : DEFAULT_STALE_AFTER;
        return this;
    }

    @Override
    public BigSegmentsConfiguration build(ClientContext context) {
        BigSegmentStore store = this.storeConfigurer == null ? null : this.storeConfigurer.build(context);
        return new BigSegmentsConfiguration(store, this.userCacheSize, this.userCacheTime, this.statusPollInterval, this.staleAfter);
    }
}

