/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import java.util.Arrays;

public enum MigrationStage {
    OFF("off"),
    DUAL_WRITE("dualwrite"),
    SHADOW("shadow"),
    LIVE("live"),
    RAMP_DOWN("rampdown"),
    COMPLETE("complete");

    private final String strValue;

    private MigrationStage(String strValue) {
        this.strValue = strValue;
    }

    public String toString() {
        return this.strValue;
    }

    public static boolean isStage(String strValue) {
        return Arrays.stream(MigrationStage.values()).anyMatch(item -> item.strValue.equals(strValue));
    }

    public static MigrationStage of(String strValue, MigrationStage defaultStage) {
        return Arrays.stream(MigrationStage.values()).filter(item -> item.strValue.equals(strValue)).findFirst().orElse(defaultStage);
    }
}

