/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.MigrationOp;
import com.launchdarkly.sdk.server.MigrationOrigin;
import com.launchdarkly.sdk.server.MigrationStage;
import com.launchdarkly.sdk.server.interfaces.ConsistencyCheck;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.Sampler;
import com.launchdarkly.shaded.org.jetbrains.annotations.NotNull;
import com.launchdarkly.shaded.org.jetbrains.annotations.Nullable;
import java.time.Duration;
import java.util.Optional;

public class MigrationOpTracker {
    private boolean oldError = false;
    private boolean newError = false;
    private boolean oldInvoked = false;
    private boolean newInvoked = false;
    private Duration oldLatency = null;
    private Duration newLatency = null;
    private MigrationOp operation = null;
    private ConsistencyCheck consistencyCheck = ConsistencyCheck.NOT_CHECKED;
    private final DataModel.FeatureFlag flag;
    private final MigrationStage stage;
    private final MigrationStage defaultStage;
    private final EvaluationDetail<String> evaluationDetail;
    private final LDContext context;
    private final String flagKey;
    private final long checkRatio;
    private final LDLogger logger;

    MigrationOpTracker(@NotNull String flagKey, @Nullable DataModel.FeatureFlag flag, @NotNull EvaluationDetail<String> evaluationDetail, @NotNull MigrationStage defaultStage, @NotNull MigrationStage stage, @NotNull LDContext context, long checkRatio, @NotNull LDLogger logger) {
        this.flag = flag;
        this.stage = stage;
        this.defaultStage = defaultStage;
        this.evaluationDetail = evaluationDetail;
        this.context = context;
        this.flagKey = flagKey;
        this.checkRatio = checkRatio;
        this.logger = logger;
    }

    public synchronized void op(@NotNull MigrationOp op) {
        this.operation = op;
    }

    public synchronized void error(@NotNull MigrationOrigin origin) {
        switch (origin) {
            case OLD: {
                this.oldError = true;
                break;
            }
            case NEW: {
                this.newError = true;
            }
        }
    }

    public synchronized void consistency(@NotNull Checker checker) {
        if (Sampler.shouldSample(this.checkRatio)) {
            try {
                this.consistencyCheck = checker.check() ? ConsistencyCheck.CONSISTENT : ConsistencyCheck.INCONSISTENT;
            }
            catch (Exception e) {
                this.logger.error("Exception when executing consistency check function for migration '{}' the consistency check will not be included in the generated migration op event. Exception: {}", (Object)this.flagKey, (Object)e);
            }
        }
    }

    public synchronized void latency(@NotNull MigrationOrigin origin, @NotNull Duration duration) {
        switch (origin) {
            case OLD: {
                this.oldLatency = duration;
                break;
            }
            case NEW: {
                this.newLatency = duration;
            }
        }
    }

    public synchronized void invoked(@NotNull MigrationOrigin origin) {
        switch (origin) {
            case OLD: {
                this.oldInvoked = true;
                break;
            }
            case NEW: {
                this.newInvoked = true;
            }
        }
    }

    private boolean invokedForOrigin(MigrationOrigin origin) {
        if (origin == MigrationOrigin.OLD) {
            return this.oldInvoked;
        }
        return this.newInvoked;
    }

    private Duration latencyForOrigin(MigrationOrigin origin) {
        if (origin == MigrationOrigin.OLD) {
            return this.oldLatency;
        }
        return this.newLatency;
    }

    private boolean errorForOrigin(MigrationOrigin origin) {
        if (origin == MigrationOrigin.OLD) {
            return this.oldError;
        }
        return this.newError;
    }

    private boolean checkOriginEventConsistency(MigrationOrigin origin) {
        if (this.invokedForOrigin(origin)) {
            return true;
        }
        String logTag = String.format("For migration op(%s) flagKey(%s):", new Object[]{this.operation, this.flagKey});
        if (this.latencyForOrigin(origin) != null) {
            this.logger.error("{} Latency was recorded for {}, but that origin was not invoked.", (Object)logTag, (Object)origin);
            return false;
        }
        if (this.errorForOrigin(origin)) {
            this.logger.error("{} Error reported for {}, but that origin was not invoked.", (Object)logTag, (Object)origin);
            return false;
        }
        if (this.consistencyCheck != ConsistencyCheck.NOT_CHECKED) {
            this.logger.error("{} Consistency check was done, but {} was not invoked. Both \"old\" and \"new\" must be invoked to do a comparison.", (Object)logTag, (Object)origin);
            return false;
        }
        return true;
    }

    private boolean checkEventConsistency() {
        return this.checkOriginEventConsistency(MigrationOrigin.OLD) && this.checkOriginEventConsistency(MigrationOrigin.NEW);
    }

    synchronized Optional<Event.MigrationOp> createEvent() {
        if (this.flagKey.isEmpty()) {
            this.logger.error("The migration was executed against an empty flag key and no event will be created.");
            return Optional.empty();
        }
        if (this.operation == null) {
            this.logger.error("The operation must be set, using \"op\" before an event can be created.");
            return Optional.empty();
        }
        if (!this.newInvoked && !this.oldInvoked) {
            this.logger.error("The migration invoked neither the \"old\" or \"new\" implementation and an event cannot be generated.");
            return Optional.empty();
        }
        if (!this.context.isValid()) {
            this.logger.error("The migration was not done against a valid context and cannot generate an event.");
            return Optional.empty();
        }
        if (!this.checkEventConsistency()) {
            return Optional.empty();
        }
        long samplingRatio = 1L;
        if (this.flag != null && this.flag.getSamplingRatio() != null) {
            samplingRatio = this.flag.getSamplingRatio();
        }
        int flagVersion = -1;
        flagVersion = this.flag != null ? this.flag.getVersion() : -1;
        Event.MigrationOp.InvokedMeasurement invokedMeasurement = new Event.MigrationOp.InvokedMeasurement(this.oldInvoked, this.newInvoked);
        Event.MigrationOp.LatencyMeasurement latencyMeasurement = null;
        if (this.oldLatency != null | this.newLatency != null) {
            latencyMeasurement = new Event.MigrationOp.LatencyMeasurement(this.oldLatency != null ? Long.valueOf(this.oldLatency.toMillis()) : null, this.newLatency != null ? Long.valueOf(this.newLatency.toMillis()) : null);
        }
        Event.MigrationOp.ConsistencyMeasurement consistencyMeasurement = null;
        if (this.consistencyCheck != ConsistencyCheck.NOT_CHECKED) {
            consistencyMeasurement = new Event.MigrationOp.ConsistencyMeasurement(this.consistencyCheck == ConsistencyCheck.CONSISTENT, this.checkRatio);
        }
        Event.MigrationOp.ErrorMeasurement errorMeasurement = null;
        if (this.oldError || this.newError) {
            errorMeasurement = new Event.MigrationOp.ErrorMeasurement(this.oldError, this.newError);
        }
        return Optional.of(new Event.MigrationOp(System.currentTimeMillis(), this.context, this.flagKey, this.evaluationDetail.getVariationIndex(), flagVersion, LDValue.of(this.stage.toString()), LDValue.of(this.defaultStage.toString()), this.evaluationDetail.getReason(), samplingRatio, this.operation.toString(), invokedMeasurement, consistencyMeasurement, latencyMeasurement, errorMeasurement));
    }

    public static interface Checker {
        public boolean check();
    }
}

