/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.LDContext;
import java.util.ArrayList;
import java.util.List;

public final class ContextMultiBuilder {
    private List<LDContext> contexts;

    ContextMultiBuilder() {
    }

    public LDContext build() {
        if (this.contexts == null || this.contexts.size() == 0) {
            return LDContext.failed("multi-kind context must contain at least one kind");
        }
        if (this.contexts.size() == 1) {
            return this.contexts.get(0);
        }
        LDContext[] contextsArray = this.contexts.toArray(new LDContext[this.contexts.size()]);
        return LDContext.createMultiInternal(contextsArray);
    }

    public ContextMultiBuilder add(LDContext context) {
        if (context != null) {
            if (this.contexts == null) {
                this.contexts = new ArrayList<LDContext>();
            }
            if (context.isMultiple()) {
                for (LDContext c : context.multiContexts) {
                    this.contexts.add(c);
                }
            } else {
                this.contexts.add(context);
            }
        }
        return this;
    }
}

