/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.shaded.com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.LazyStackTrace;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.Logger;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.MessageEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

final class AsyncEventHandler
implements EventHandler {
    private final Executor executor;
    private final EventHandler eventSourceHandler;
    private final Logger logger;
    final Semaphore semaphore;

    AsyncEventHandler(Executor executor, EventHandler eventSourceHandler, Logger logger, Semaphore semaphore) {
        this.executor = executor;
        this.eventSourceHandler = eventSourceHandler;
        this.logger = logger;
        this.semaphore = semaphore;
    }

    @Override
    public void onOpen() {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onOpen();
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onClosed() {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onClosed();
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onComment(String comment) {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onComment(comment);
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onMessage(String event, MessageEvent messageEvent) {
        this.execute(() -> {
            try {
                this.eventSourceHandler.onMessage(event, messageEvent);
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
            finally {
                messageEvent.close();
            }
        });
    }

    @Override
    public void onError(Throwable error) {
        this.execute(() -> this.onErrorInternal(error));
    }

    private void handleUnexpectedError(Throwable error) {
        this.logger.warn("Caught unexpected error from EventHandler: " + error.toString());
        this.logger.debug("Stack trace: {}", new LazyStackTrace(error));
        this.onErrorInternal(error);
    }

    private void onErrorInternal(Throwable error) {
        try {
            this.eventSourceHandler.onError(error);
        }
        catch (Throwable errorFromErrorHandler) {
            this.logger.warn("Caught unexpected error from EventHandler.onError(): " + errorFromErrorHandler.toString());
            this.logger.debug("Stack trace: {}", new LazyStackTrace(error));
        }
    }

    private void execute(Runnable task) {
        this.acquire();
        try {
            this.executor.execute(() -> {
                try {
                    task.run();
                }
                finally {
                    this.release();
                }
            });
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    private void acquire() {
        if (this.semaphore != null) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Thread interrupted while waiting for event thread semaphore", e);
            }
        }
    }

    private void release() {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }
}

