/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.launchdarkly.sdk.Function;
import java.io.IOException;
import java.util.Iterator;

abstract class Helpers {
    private Helpers() {
    }

    static <T, U> Iterable<U> transform(final Iterable<T> source, final Function<T, U> fn) {
        return new Iterable<U>(){

            @Override
            public Iterator<U> iterator() {
                final Iterator sourceIterator = source.iterator();
                return new Iterator<U>(){

                    @Override
                    public boolean hasNext() {
                        return sourceIterator.hasNext();
                    }

                    @Override
                    public U next() {
                        return fn.apply(sourceIterator.next());
                    }
                };
            }
        };
    }

    static String readNullableString(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case STRING: {
                return reader.nextString();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new JsonParseException("expected string value or null");
    }

    static String readNonNullableString(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case STRING: {
                return reader.nextString();
            }
        }
        throw new JsonParseException("expected string value");
    }

    static <T extends Enum<T>> T readEnum(Class<T> enumClass, JsonReader reader) throws IOException {
        String s = Helpers.readNonNullableString(reader);
        try {
            return Enum.valueOf(enumClass, s);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException(String.format("unsupported value \"%s\" for %s", s, enumClass));
        }
    }
}

