/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android.integrations;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.android.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.android.subsystems.EventProcessor;
import java.util.HashSet;
import java.util.Set;

public abstract class EventProcessorBuilder
implements ComponentConfigurer<EventProcessor> {
    public static final int DEFAULT_CAPACITY = 100;
    public static final int DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL_MILLIS = 900000;
    public static final int DEFAULT_FLUSH_INTERVAL_MILLIS = 30000;
    public static final int MIN_DIAGNOSTIC_RECORDING_INTERVAL_MILLIS = 300000;
    protected boolean allAttributesPrivate = false;
    protected int capacity = 100;
    protected int diagnosticRecordingIntervalMillis = 900000;
    protected int flushIntervalMillis = 30000;
    protected Set<AttributeRef> privateAttributes;

    public EventProcessorBuilder allAttributesPrivate(boolean allAttributesPrivate) {
        this.allAttributesPrivate = allAttributesPrivate;
        return this;
    }

    public EventProcessorBuilder capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public EventProcessorBuilder diagnosticRecordingIntervalMillis(int diagnosticRecordingIntervalMillis) {
        this.diagnosticRecordingIntervalMillis = diagnosticRecordingIntervalMillis < 300000 ? 300000 : diagnosticRecordingIntervalMillis;
        return this;
    }

    public EventProcessorBuilder flushIntervalMillis(int flushIntervalMillis) {
        this.flushIntervalMillis = flushIntervalMillis <= 0 ? 30000 : flushIntervalMillis;
        return this;
    }

    public EventProcessorBuilder privateAttributes(String ... attributeNames) {
        this.privateAttributes = new HashSet<AttributeRef>();
        for (String a : attributeNames) {
            this.privateAttributes.add(AttributeRef.fromPath((String)a));
        }
        return this;
    }
}

