/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android.env;

import android.app.Application;
import androidx.annotation.Nullable;
import com.launchdarkly.sdk.android.env.AndroidEnvironmentReporter;
import com.launchdarkly.sdk.android.env.ApplicationInfoEnvironmentReporter;
import com.launchdarkly.sdk.android.env.EnvironmentReporterChainBase;
import com.launchdarkly.sdk.android.env.IEnvironmentReporter;
import com.launchdarkly.sdk.android.env.SDKEnvironmentReporter;
import com.launchdarkly.sdk.android.subsystems.ApplicationInfo;
import java.util.ArrayList;

public class EnvironmentReporterBuilder {
    @Nullable
    private Application application;
    @Nullable
    private ApplicationInfo applicationInfo;

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public void enableCollectionFromPlatform(Application application) {
        this.application = application;
    }

    public IEnvironmentReporter build() {
        ArrayList<EnvironmentReporterChainBase> reporters = new ArrayList<EnvironmentReporterChainBase>();
        if (this.applicationInfo != null) {
            reporters.add(new ApplicationInfoEnvironmentReporter(this.applicationInfo));
        }
        if (this.application != null) {
            reporters.add(new AndroidEnvironmentReporter(this.application));
        }
        reporters.add(new SDKEnvironmentReporter());
        for (int i = 0; i < reporters.size() - 1; ++i) {
            ((EnvironmentReporterChainBase)reporters.get(i)).setNext((EnvironmentReporterChainBase)reporters.get(i + 1));
        }
        return (IEnvironmentReporter)reporters.get(0);
    }
}

