/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import android.app.Application;
import android.content.SharedPreferences;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.android.subsystems.PersistentDataStore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class SharedPreferencesPersistentDataStore
implements PersistentDataStore {
    private final Application application;
    private final LDLogger logger;

    public SharedPreferencesPersistentDataStore(Application application, LDLogger logger) {
        this.application = application;
        this.logger = logger;
    }

    public SharedPreferencesPersistentDataStore(Application application) {
        this(application, LDLogger.none());
    }

    @Override
    public String getValue(String storeNamespace, String key) {
        SharedPreferences prefs = this.getSharedPreferences(storeNamespace);
        try {
            String ret = prefs.getString(key, null);
            return ret;
        }
        catch (ClassCastException e) {
            try {
                Long longValue = prefs.getLong(key, 0L);
                return longValue == null ? null : String.valueOf(longValue);
            }
            catch (ClassCastException e1) {
                return null;
            }
        }
    }

    @Override
    public void setValue(String storeNamespace, String key, String value) {
        SharedPreferences prefs = this.getSharedPreferences(storeNamespace);
        SharedPreferences.Editor editor = prefs.edit();
        if (value == null) {
            editor.remove(key);
        } else {
            editor.putString(key, value);
        }
        editor.apply();
    }

    @Override
    public void setValues(String storeNamespace, Map<String, String> keysAndValues) {
        SharedPreferences prefs = this.getSharedPreferences(storeNamespace);
        SharedPreferences.Editor editor = prefs.edit();
        for (Map.Entry<String, String> kv : keysAndValues.entrySet()) {
            editor.putString(kv.getKey(), kv.getValue());
        }
        editor.apply();
    }

    @Override
    public Collection<String> getKeys(String storeNamespace) {
        SharedPreferences prefs = this.getSharedPreferences(storeNamespace);
        return prefs.getAll().keySet();
    }

    @Override
    public Collection<String> getAllNamespaces() {
        File directory = new File(this.application.getFilesDir().getParent() + "/shared_prefs/");
        File[] files = directory.listFiles();
        ArrayList<String> ret = new ArrayList<String>();
        if (files == null) {
            return ret;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
            ret.add(file.getName().substring(0, file.getName().length() - 4));
        }
        return ret;
    }

    @Override
    public void clear(String storeNamespace, boolean fullyDelete) {
        SharedPreferences prefs = this.getSharedPreferences(storeNamespace);
        prefs.edit().clear().apply();
        if (fullyDelete) {
            File file = new File(this.application.getFilesDir().getParent() + "/shared_prefs/" + storeNamespace + ".xml");
            file.delete();
        }
    }

    private SharedPreferences getSharedPreferences(String storeNamespace) {
        return this.application.getSharedPreferences(storeNamespace, 0);
    }
}

