/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.android.AndroidPlatformState;
import com.launchdarkly.sdk.android.AndroidTaskExecutor;
import com.launchdarkly.sdk.android.AnonymousKeyContextModifier;
import com.launchdarkly.sdk.android.AutoEnvContextModifier;
import com.launchdarkly.sdk.android.ClientContextImpl;
import com.launchdarkly.sdk.android.ComponentsImpl;
import com.launchdarkly.sdk.android.ConnectionInformation;
import com.launchdarkly.sdk.android.ConnectivityManager;
import com.launchdarkly.sdk.android.ContextDataManager;
import com.launchdarkly.sdk.android.DataModel;
import com.launchdarkly.sdk.android.EnvironmentData;
import com.launchdarkly.sdk.android.FeatureFlagChangeListener;
import com.launchdarkly.sdk.android.HttpFeatureFlagFetcher;
import com.launchdarkly.sdk.android.IContextModifier;
import com.launchdarkly.sdk.android.LDAllFlagsListener;
import com.launchdarkly.sdk.android.LDAwaitFuture;
import com.launchdarkly.sdk.android.LDClientInterface;
import com.launchdarkly.sdk.android.LDConfig;
import com.launchdarkly.sdk.android.LDFailedFuture;
import com.launchdarkly.sdk.android.LDStatusListener;
import com.launchdarkly.sdk.android.LDSuccessFuture;
import com.launchdarkly.sdk.android.LDUtil;
import com.launchdarkly.sdk.android.LaunchDarklyException;
import com.launchdarkly.sdk.android.Migration;
import com.launchdarkly.sdk.android.NoOpContextModifier;
import com.launchdarkly.sdk.android.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.android.PlatformState;
import com.launchdarkly.sdk.android.SharedPreferencesPersistentDataStore;
import com.launchdarkly.sdk.android.TaskExecutor;
import com.launchdarkly.sdk.android.env.EnvironmentReporterBuilder;
import com.launchdarkly.sdk.android.env.IEnvironmentReporter;
import com.launchdarkly.sdk.android.subsystems.Callback;
import com.launchdarkly.sdk.android.subsystems.EventProcessor;
import com.launchdarkly.sdk.android.subsystems.PersistentDataStore;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class LDClient
implements LDClientInterface,
Closeable {
    static volatile Map<String, LDClient> instances = null;
    private volatile ClientContextImpl clientContextImpl;
    private static IContextModifier autoEnvContextModifier;
    private static IContextModifier anonymousKeyContextModifier;
    static Object initLock;
    private static volatile LDLogger sharedLogger;
    private final LDConfig config;
    private final ContextDataManager contextDataManager;
    private final EventProcessor eventProcessor;
    private final ConnectivityManager connectivityManager;
    private final LDLogger logger;
    private static final int EXCESSIVE_INIT_WAIT_SECONDS = 15;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Future<LDClient> init(@NonNull Application application, @NonNull LDConfig config, @NonNull LDContext context) {
        LDClient primaryClient;
        LDContext modifiedContext;
        if (application == null) {
            return new LDFailedFuture<LDClient>(new LaunchDarklyException("Client initialization requires a valid application"));
        }
        if (config == null) {
            return new LDFailedFuture<LDClient>(new LaunchDarklyException("Client initialization requires a valid configuration"));
        }
        if (context == null || !context.isValid()) {
            return new LDFailedFuture<LDClient>(new LaunchDarklyException("Client initialization requires a valid evaluation context (" + (context == null ? "was null" : context.getError() + ")")));
        }
        LDLogger logger = LDClient.initSharedLogger(config);
        final LDAwaitFuture<LDClient> resultFuture = new LDAwaitFuture<LDClient>();
        Object object = initLock;
        synchronized (object) {
            if (instances != null) {
                logger.warn((Object)"LDClient.init() was called more than once! returning primary instance.");
                return new LDSuccessFuture<LDClient>(instances.get("default"));
            }
            AndroidTaskExecutor sharedTaskExecutor = new AndroidTaskExecutor(application, logger);
            AndroidPlatformState sharedPlatformState = new AndroidPlatformState(application, sharedTaskExecutor, logger);
            PersistentDataStore store = config.getPersistentDataStore() == null ? new SharedPreferencesPersistentDataStore(application, logger) : config.getPersistentDataStore();
            PersistentDataStoreWrapper persistentData = new PersistentDataStoreWrapper(store, logger);
            Migration.migrateWhenNeeded(store, logger);
            EnvironmentReporterBuilder reporterBuilder = new EnvironmentReporterBuilder();
            reporterBuilder.setApplicationInfo(config.applicationInfo);
            if (config.isAutoEnvAttributes()) {
                reporterBuilder.enableCollectionFromPlatform(application);
            }
            IEnvironmentReporter environmentReporter = reporterBuilder.build();
            autoEnvContextModifier = config.isAutoEnvAttributes() ? new AutoEnvContextModifier(persistentData, environmentReporter, logger) : new NoOpContextModifier();
            anonymousKeyContextModifier = new AnonymousKeyContextModifier(persistentData, config.isGenerateAnonymousKeys());
            modifiedContext = autoEnvContextModifier.modifyContext(context);
            modifiedContext = anonymousKeyContextModifier.modifyContext(modifiedContext);
            HashMap<String, LDClient> newInstances = new HashMap<String, LDClient>();
            LDClient createdPrimaryClient = null;
            for (Map.Entry<String, String> mobileKeys : config.getMobileKeys().entrySet()) {
                String envName = mobileKeys.getKey();
                String mobileKey = mobileKeys.getValue();
                try {
                    LDClient instance = new LDClient(sharedPlatformState, environmentReporter, sharedTaskExecutor, persistentData.perEnvironmentData(mobileKey), modifiedContext, config, mobileKey, envName);
                    newInstances.put(envName, instance);
                    if (!mobileKey.equals(config.getMobileKey())) continue;
                    createdPrimaryClient = instance;
                }
                catch (LaunchDarklyException e) {
                    resultFuture.setException(e);
                    return resultFuture;
                }
            }
            primaryClient = createdPrimaryClient;
            instances = newInstances;
        }
        final AtomicInteger initCounter = new AtomicInteger(config.getMobileKeys().size());
        Callback<Void> completeWhenCounterZero = new Callback<Void>(){

            @Override
            public void onSuccess(Void result) {
                if (initCounter.decrementAndGet() == 0) {
                    resultFuture.set(primaryClient);
                }
            }

            @Override
            public void onError(Throwable e) {
                resultFuture.setException(e);
            }
        };
        for (LDClient instance : instances.values()) {
            if (!instance.connectivityManager.startUp(completeWhenCounterZero)) continue;
            instance.eventProcessor.recordIdentifyEvent(modifiedContext);
        }
        return resultFuture;
    }

    public static LDClient init(Application application, LDConfig config, LDContext context, int startWaitSeconds) {
        LDClient.initSharedLogger(config);
        LDClient.getSharedLogger().info("Initializing Client and waiting up to {} for initialization to complete", (Object)startWaitSeconds);
        if (startWaitSeconds >= 15) {
            LDClient.getSharedLogger().warn("LDClient.init called with start wait time parameter of {} seconds.  We recommend a timeout of less than {} seconds.", (Object)startWaitSeconds, (Object)15);
        }
        Future<LDClient> initFuture = LDClient.init(application, config, context);
        try {
            return initFuture.get(startWaitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            LDClient.getSharedLogger().error("Exception during Client initialization: {}", LogValues.exceptionSummary((Throwable)e));
            LDClient.getSharedLogger().debug(LogValues.exceptionTrace((Throwable)e));
        }
        catch (TimeoutException e) {
            LDClient.getSharedLogger().warn("Client did not successfully initialize within {} seconds. It could be taking longer than expected to fetch data. Client can be used immediately and will continue retrying in the background.", (Object)startWaitSeconds);
        }
        return instances.get("default");
    }

    public static LDClient get() throws LaunchDarklyException {
        if (instances == null) {
            LDClient.getSharedLogger().error((Object)"LDClient.get() was called before init()!");
            throw new LaunchDarklyException("LDClient.get() was called before init()!");
        }
        return instances.get("default");
    }

    public static LDClient getForMobileKey(String keyName) throws LaunchDarklyException {
        Map<String, LDClient> instancesNow = instances;
        if (instancesNow == null) {
            LDClient.getSharedLogger().error((Object)"LDClient.getForMobileKey() was called before init()!");
            throw new LaunchDarklyException("LDClient.getForMobileKey() was called before init()!");
        }
        if (!instancesNow.containsKey(keyName)) {
            throw new LaunchDarklyException("LDClient.getForMobileKey() called with invalid keyName");
        }
        return instancesNow.get(keyName);
    }

    @VisibleForTesting
    protected LDClient(@NonNull PlatformState platformState, @NonNull IEnvironmentReporter environmentReporter, @NonNull TaskExecutor taskExecutor, @NonNull PersistentDataStoreWrapper.PerEnvironmentData environmentStore, @NonNull LDContext initialContext, @NonNull LDConfig config, @NonNull String mobileKey, @NonNull String environmentName) throws LaunchDarklyException {
        this.logger = LDLogger.withAdapter((LDLogAdapter)config.getLogAdapter(), (String)config.getLoggerName());
        this.logger.info("Creating LaunchDarkly client. Version: {}", (Object)"5.4.0");
        this.config = config;
        if (mobileKey == null) {
            throw new LaunchDarklyException("Mobile key cannot be null");
        }
        HttpFeatureFlagFetcher fetcher = null;
        if (config.dataSource instanceof ComponentsImpl.DataSourceRequiresFeatureFetcher) {
            ClientContextImpl minimalContext = ClientContextImpl.fromConfig(config, mobileKey, environmentName, null, initialContext, this.logger, platformState, environmentReporter, taskExecutor);
            fetcher = new HttpFeatureFlagFetcher(minimalContext);
        }
        this.clientContextImpl = ClientContextImpl.fromConfig(config, mobileKey, environmentName, fetcher, initialContext, this.logger, platformState, environmentReporter, taskExecutor);
        this.contextDataManager = new ContextDataManager(this.clientContextImpl, environmentStore, config.getMaxCachedContexts());
        this.eventProcessor = config.events.build(this.clientContextImpl);
        this.connectivityManager = new ConnectivityManager(this.clientContextImpl, config.dataSource, this.eventProcessor, this.contextDataManager, environmentStore);
    }

    @Override
    public void trackMetric(String eventName, LDValue data, double metricValue) {
        this.trackInternal(eventName, data, metricValue);
    }

    @Override
    public void trackData(String eventName, LDValue data) {
        this.trackInternal(eventName, data, null);
    }

    @Override
    public void track(String eventName) {
        this.trackInternal(eventName, null, null);
    }

    private void trackInternal(String eventName, LDValue data, Double metricValue) {
        this.eventProcessor.recordCustomEvent(this.clientContextImpl.getEvaluationContext(), eventName, data, metricValue);
    }

    @Override
    public Future<Void> identify(LDContext context) {
        if (context == null) {
            return new LDFailedFuture<Void>(new LaunchDarklyException("Context cannot be null"));
        }
        if (!context.isValid()) {
            this.logger.warn("identify() was called with an invalid context: {}", (Object)context.getError());
            return new LDFailedFuture<Void>(new LaunchDarklyException("Invalid context: " + context.getError()));
        }
        LDContext modifiedContext = autoEnvContextModifier.modifyContext(context);
        modifiedContext = anonymousKeyContextModifier.modifyContext(modifiedContext);
        return this.identifyInstances(modifiedContext);
    }

    @NonNull
    private Map<String, LDClient> getInstancesIfTheyIncludeThisClient() {
        Map<String, LDClient> ret = instances;
        if (ret != null) {
            for (LDClient c : ret.values()) {
                if (c != this) continue;
                return ret;
            }
        }
        return Collections.emptyMap();
    }

    private void identifyInternal(@NonNull LDContext context, Callback<Void> onCompleteListener) {
        this.clientContextImpl = this.clientContextImpl.setEvaluationContext(context);
        this.contextDataManager.switchToContext(context);
        this.connectivityManager.switchToContext(context, onCompleteListener);
        this.eventProcessor.recordIdentifyEvent(context);
    }

    private Future<Void> identifyInstances(@NonNull LDContext context) {
        final LDAwaitFuture<Void> resultFuture = new LDAwaitFuture<Void>();
        Map<String, LDClient> instancesNow = this.getInstancesIfTheyIncludeThisClient();
        final AtomicInteger identifyCounter = new AtomicInteger(instancesNow.size());
        Callback<Void> completeWhenCounterZero = new Callback<Void>(){

            @Override
            public void onSuccess(Void result) {
                if (identifyCounter.decrementAndGet() == 0) {
                    resultFuture.set(null);
                }
            }

            @Override
            public void onError(Throwable e) {
                resultFuture.setException(e);
            }
        };
        for (LDClient client : instancesNow.values()) {
            client.identifyInternal(context, completeWhenCounterZero);
        }
        return resultFuture;
    }

    @Override
    public Map<String, LDValue> allFlags() {
        EnvironmentData allData = this.contextDataManager.getAllNonDeleted();
        HashMap<String, LDValue> flagValues = new HashMap<String, LDValue>();
        for (DataModel.Flag flag : allData.values()) {
            flagValues.put(flag.getKey(), flag.getValue());
        }
        return flagValues;
    }

    @Override
    public boolean boolVariation(@NonNull String key, boolean defaultValue) {
        return ((LDValue)this.variationDetailInternal(key, LDValue.of((boolean)defaultValue), true, false).getValue()).booleanValue();
    }

    @Override
    public EvaluationDetail<Boolean> boolVariationDetail(@NonNull String key, boolean defaultValue) {
        return this.convertDetailType(this.variationDetailInternal(key, LDValue.of((boolean)defaultValue), true, true), LDValue.Convert.Boolean);
    }

    @Override
    public int intVariation(@NonNull String key, int defaultValue) {
        return ((LDValue)this.variationDetailInternal(key, LDValue.of((int)defaultValue), true, false).getValue()).intValue();
    }

    @Override
    public EvaluationDetail<Integer> intVariationDetail(@NonNull String key, int defaultValue) {
        return this.convertDetailType(this.variationDetailInternal(key, LDValue.of((int)defaultValue), true, true), LDValue.Convert.Integer);
    }

    @Override
    public double doubleVariation(String flagKey, double defaultValue) {
        return ((LDValue)this.variationDetailInternal(flagKey, LDValue.of((double)defaultValue), true, false).getValue()).doubleValue();
    }

    @Override
    public EvaluationDetail<Double> doubleVariationDetail(String flagKey, double defaultValue) {
        return this.convertDetailType(this.variationDetailInternal(flagKey, LDValue.of((double)defaultValue), true, true), LDValue.Convert.Double);
    }

    @Override
    public String stringVariation(@NonNull String key, String defaultValue) {
        return ((LDValue)this.variationDetailInternal(key, LDValue.of((String)defaultValue), true, false).getValue()).stringValue();
    }

    @Override
    public EvaluationDetail<String> stringVariationDetail(@NonNull String key, String defaultValue) {
        return this.convertDetailType(this.variationDetailInternal(key, LDValue.of((String)defaultValue), true, true), LDValue.Convert.String);
    }

    @Override
    public LDValue jsonValueVariation(@NonNull String key, LDValue defaultValue) {
        return (LDValue)this.variationDetailInternal(key, LDValue.normalize((LDValue)defaultValue), false, false).getValue();
    }

    @Override
    public EvaluationDetail<LDValue> jsonValueVariationDetail(@NonNull String key, LDValue defaultValue) {
        return this.variationDetailInternal(key, LDValue.normalize((LDValue)defaultValue), false, true);
    }

    private <T> EvaluationDetail<T> convertDetailType(EvaluationDetail<LDValue> detail, LDValue.Converter<T> converter) {
        return EvaluationDetail.fromValue((Object)converter.toType((LDValue)detail.getValue()), (int)detail.getVariationIndex(), (EvaluationReason)detail.getReason());
    }

    private EvaluationDetail<LDValue> variationDetailInternal(@NonNull String key, @NonNull LDValue defaultValue, boolean checkType, boolean needsReason) {
        EvaluationDetail result;
        LDContext context = this.clientContextImpl.getEvaluationContext();
        DataModel.Flag flag = this.contextDataManager.getNonDeletedFlag(key);
        if (flag == null) {
            this.logger.info("Unknown feature flag \"{}\"; returning default value", (Object)key);
            this.eventProcessor.recordEvaluationEvent(context, key, -1, -1, defaultValue, null, defaultValue, false, null);
            result = EvaluationDetail.fromValue((Object)defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.FLAG_NOT_FOUND));
        } else {
            int variation;
            if (flag.getPrerequisites() != null) {
                for (String prereqKey : flag.getPrerequisites()) {
                    this.variationDetailInternal(prereqKey, LDValue.ofNull(), false, false);
                }
            }
            LDValue value = flag.getValue();
            int n = variation = flag.getVariation() == null ? -1 : flag.getVariation();
            if (value.isNull()) {
                this.logger.warn("Feature flag \"{}\" retrieved with no value; returning default value", (Object)key);
                value = defaultValue;
                result = EvaluationDetail.fromValue((Object)defaultValue, (int)variation, (EvaluationReason)flag.getReason());
            } else if (checkType && !defaultValue.isNull() && value.getType() != defaultValue.getType()) {
                this.logger.warn("Feature flag \"{}\" with type {} retrieved as {}; returning default value", new Object[]{key, value.getType(), defaultValue.getType()});
                value = defaultValue;
                result = EvaluationDetail.fromValue((Object)defaultValue, (int)-1, (EvaluationReason)EvaluationReason.error((EvaluationReason.ErrorKind)EvaluationReason.ErrorKind.WRONG_TYPE));
            } else {
                result = EvaluationDetail.fromValue((Object)value, (int)variation, (EvaluationReason)flag.getReason());
            }
            this.eventProcessor.recordEvaluationEvent(context, key, flag.getVersionForEvents(), flag.getVariation() == null ? -1 : flag.getVariation(), value, flag.isTrackReason() | needsReason ? result.getReason() : null, defaultValue, flag.isTrackEvents(), flag.getDebugEventsUntilDate());
        }
        this.logger.debug("returning variation: {} flagKey: {} context key: {}", new Object[]{result, key, context.getKey()});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.closeInstances();
        Object object = initLock;
        synchronized (object) {
            this.clientContextImpl.getTaskExecutor().close();
            this.clientContextImpl.getPlatformState().close();
        }
    }

    private void closeInternal() {
        this.connectivityManager.shutDown();
        try {
            this.eventProcessor.close();
        }
        catch (IOException e) {
            LDUtil.logExceptionAtWarnLevel(this.logger, e, "Unexpected exception from closing event processor", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInstances() {
        Collection<LDClient> oldClients;
        Iterator iterator = initLock;
        synchronized (iterator) {
            oldClients = this.getInstancesIfTheyIncludeThisClient().values();
            instances = null;
        }
        for (LDClient client : oldClients) {
            client.closeInternal();
        }
        sharedLogger = null;
    }

    @Override
    public void flush() {
        for (LDClient client : this.getInstancesIfTheyIncludeThisClient().values()) {
            client.flushInternal();
        }
    }

    private void flushInternal() {
        this.eventProcessor.flush();
    }

    @VisibleForTesting
    void blockingFlush() {
        this.eventProcessor.blockingFlush();
    }

    @Override
    public boolean isInitialized() {
        return this.connectivityManager.isForcedOffline() || this.connectivityManager.isInitialized();
    }

    @Override
    public boolean isOffline() {
        return this.connectivityManager.isForcedOffline();
    }

    @Override
    public void setOffline() {
        for (LDClient client : this.getInstancesIfTheyIncludeThisClient().values()) {
            client.setOfflineInternal();
        }
    }

    private void setOfflineInternal() {
        this.connectivityManager.setForceOffline(true);
    }

    @Override
    public void setOnline() {
        for (LDClient client : this.getInstancesIfTheyIncludeThisClient().values()) {
            client.setOnlineStatusInternal();
        }
    }

    private void setOnlineStatusInternal() {
        this.connectivityManager.setForceOffline(false);
    }

    @Override
    public void registerFeatureFlagListener(String flagKey, FeatureFlagChangeListener listener) {
        this.contextDataManager.registerListener(flagKey, listener);
    }

    @Override
    public void unregisterFeatureFlagListener(String flagKey, FeatureFlagChangeListener listener) {
        this.contextDataManager.unregisterListener(flagKey, listener);
    }

    @Override
    public boolean isDisableBackgroundPolling() {
        return this.config.isDisableBackgroundPolling();
    }

    @Override
    public ConnectionInformation getConnectionInformation() {
        return this.connectivityManager.getConnectionInformation();
    }

    @Override
    public void registerStatusListener(LDStatusListener statusListener) {
        this.connectivityManager.registerStatusListener(statusListener);
    }

    @Override
    public void unregisterStatusListener(LDStatusListener statusListener) {
        this.connectivityManager.unregisterStatusListener(statusListener);
    }

    @Override
    public void registerAllFlagsListener(LDAllFlagsListener allFlagsListener) {
        this.contextDataManager.registerAllFlagsListener(allFlagsListener);
    }

    @Override
    public void unregisterAllFlagsListener(LDAllFlagsListener allFlagsListener) {
        this.contextDataManager.unregisterAllFlagsListener(allFlagsListener);
    }

    @Override
    public String getVersion() {
        return "5.4.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LDLogger initSharedLogger(LDConfig config) {
        Object object = initLock;
        synchronized (object) {
            if (sharedLogger == null) {
                sharedLogger = LDLogger.withAdapter((LDLogAdapter)config.getLogAdapter(), (String)config.getLoggerName());
            }
            return sharedLogger;
        }
    }

    static LDLogger getSharedLogger() {
        LDLogger logger = sharedLogger;
        if (logger != null) {
            return logger;
        }
        return LDLogger.none();
    }

    static {
        initLock = new Object();
    }
}

