/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.json.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

final class ContextIndex {
    final List<IndexEntry> data;

    ContextIndex() {
        this(new ArrayList<IndexEntry>());
    }

    ContextIndex(List<IndexEntry> data) {
        this.data = data == null ? new ArrayList() : data;
    }

    public ContextIndex updateTimestamp(String hashedContextId, long timestamp) {
        ArrayList<IndexEntry> newData = new ArrayList<IndexEntry>();
        for (IndexEntry e : this.data) {
            if (e.contextId.equals(hashedContextId)) continue;
            newData.add(e);
        }
        newData.add(new IndexEntry(hashedContextId, timestamp));
        return new ContextIndex(newData);
    }

    public ContextIndex prune(int maxContextsToRetain, List<String> removedIdsOut) {
        if (this.data.size() <= maxContextsToRetain || maxContextsToRetain < 0) {
            return this;
        }
        IndexEntry[] items = this.data.toArray(new IndexEntry[this.data.size()]);
        Arrays.sort(items, new Comparator<IndexEntry>(){

            @Override
            public int compare(IndexEntry o1, IndexEntry o2) {
                return Long.compare(o1.timestamp, o2.timestamp);
            }
        });
        ArrayList<IndexEntry> newData = new ArrayList<IndexEntry>(Arrays.asList(items));
        int numDrop = newData.size() - maxContextsToRetain;
        for (int i = 0; i < numDrop; ++i) {
            removedIdsOut.add(((IndexEntry)newData.get((int)0)).contextId);
            newData.remove(0);
        }
        return new ContextIndex(newData);
    }

    public static ContextIndex fromJson(String json) throws SerializationException {
        ArrayList<IndexEntry> out = new ArrayList<IndexEntry>();
        JsonReader r = new JsonReader((Reader)new StringReader(json));
        try {
            r.beginArray();
            while (r.hasNext()) {
                r.beginArray();
                if (r.hasNext()) {
                    String contextId = r.nextString();
                    if (r.hasNext()) {
                        long timestamp = r.nextLong();
                        out.add(new IndexEntry(contextId, timestamp));
                    }
                }
                while (r.hasNext()) {
                }
                r.endArray();
            }
            r.endArray();
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
        return new ContextIndex(out);
    }

    public String toJson() {
        StringWriter sw = new StringWriter();
        try {
            JsonWriter w = new JsonWriter((Writer)sw);
            w.beginArray();
            for (IndexEntry e : this.data) {
                w.beginArray();
                w.value(e.contextId);
                w.value(e.timestamp);
                w.endArray();
            }
            w.endArray();
            w.flush();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return sw.toString();
    }

    static class IndexEntry {
        final String contextId;
        final long timestamp;

        IndexEntry(String contextId, long timestamp) {
            this.contextId = contextId;
            this.timestamp = timestamp;
        }
    }
}

