/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.im.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.im.v1.model.CreateImageReq;
import com.lark.oapi.service.im.v1.model.CreateImageResp;
import com.lark.oapi.service.im.v1.model.GetImageReq;
import com.lark.oapi.service.im.v1.model.GetImageResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Image {
    private static final Logger log = LoggerFactory.getLogger(Image.class);
    private final Config config;

    public Image(Config config) {
        this.config = config;
    }

    public CreateImageResp create(CreateImageReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/im/v1/images", Sets.newHashSet(AccessTokenType.Tenant), req);
        CreateImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateImageResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/im/v1/images", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public CreateImageResp create(CreateImageReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/im/v1/images", Sets.newHashSet(AccessTokenType.Tenant), req);
        CreateImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateImageResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/im/v1/images", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetImageResp get(GetImageReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/im/v1/images/:image_key", Sets.newHashSet(AccessTokenType.Tenant), req);
        if (httpResponse.getStatusCode() == 200) {
            GetImageResp resp = new GetImageResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        GetImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetImageResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/im/v1/images/:image_key", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetImageResp get(GetImageReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportDownLoad(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/im/v1/images/:image_key", Sets.newHashSet(AccessTokenType.Tenant), req);
        if (httpResponse.getStatusCode() == 200) {
            GetImageResp resp = new GetImageResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        GetImageResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetImageResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/im/v1/images/:image_key", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

