/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.document_ai.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.document_ai.v1.model.RecognizeVatInvoiceReq;
import com.lark.oapi.service.document_ai.v1.model.RecognizeVatInvoiceResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VatInvoice {
    private static final Logger log = LoggerFactory.getLogger(VatInvoice.class);
    private final Config config;

    public VatInvoice(Config config) {
        this.config = config;
    }

    public RecognizeVatInvoiceResp recognize(RecognizeVatInvoiceReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/vat_invoice/recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
        RecognizeVatInvoiceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeVatInvoiceResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/vat_invoice/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public RecognizeVatInvoiceResp recognize(RecognizeVatInvoiceReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/vat_invoice/recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
        RecognizeVatInvoiceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeVatInvoiceResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/vat_invoice/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

