/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.binding_recyclerview.binding_adapter;

import androidx.databinding.BindingAdapter;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.kunminx.binding_recyclerview.layout_manager.WrapContentGridLayoutManager;
import com.kunminx.binding_recyclerview.layout_manager.WrapContentLinearLayoutManager;
import com.kunminx.binding_recyclerview.layout_manager.WrapContentStaggeredGridLayoutManager;
import java.util.List;

public class RecyclerViewBindingAdapter {
    @BindingAdapter(value={"adapter", "submitList", "autoScrollToTopWhenInsert", "autoScrollToBottomWhenInsert"}, requireAll=false)
    public static void bindList(final RecyclerView recyclerView, ListAdapter adapter, List list, final boolean autoScrollToTopWhenInsert, final boolean autoScrollToBottomWhenInsert) {
        if (recyclerView != null && list != null) {
            if (recyclerView.getAdapter() == null) {
                if (recyclerView.getLayoutManager() != null) {
                    if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
                        int spanCount = ((GridLayoutManager)recyclerView.getLayoutManager()).getSpanCount();
                        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new WrapContentGridLayoutManager(recyclerView.getContext(), spanCount));
                    } else if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
                        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new WrapContentLinearLayoutManager(recyclerView.getContext()));
                    } else if (recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
                        int spanCount = ((StaggeredGridLayoutManager)recyclerView.getLayoutManager()).getSpanCount();
                        int orientation = ((StaggeredGridLayoutManager)recyclerView.getLayoutManager()).getOrientation();
                        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new WrapContentStaggeredGridLayoutManager(spanCount, orientation));
                    }
                }
                recyclerView.setAdapter((RecyclerView.Adapter)adapter);
                adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

                    public void onItemRangeInserted(int positionStart, int itemCount) {
                        if (autoScrollToTopWhenInsert) {
                            recyclerView.scrollToPosition(0);
                        } else if (autoScrollToBottomWhenInsert) {
                            recyclerView.scrollToPosition(recyclerView.getAdapter().getItemCount());
                        }
                    }
                });
            }
            adapter.submitList(list);
        }
    }

    @BindingAdapter(value={"notifyCurrentListChanged"})
    public static void notifyListChanged(RecyclerView recyclerView, boolean notify) {
        if (notify && recyclerView != null && recyclerView.getAdapter() != null) {
            recyclerView.getAdapter().notifyDataSetChanged();
        }
    }
}

