/*
 * Decompiled with CFR 0.152.
 */
package pl.kro9bits.customizable_progress_bar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.text.NumberFormat;
import java.util.Locale;
import pl.kro9bits.customizable_progress_bar.CustomProgressBar;
import pl.kro9bits.customizable_progress_bar.R;

public class CustomizableProgressBar
extends RelativeLayout {
    private RightTextMode rightTextMode = RightTextMode.CUSTOM;
    private CustomProgressBar progressBar;
    private TextView text_left;
    private TextView text_right;
    private ImageView icon_left;
    private ImageView icon_right;

    public CustomizableProgressBar(Context context) {
        super(context);
        this.init();
    }

    public CustomizableProgressBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CustomizableProgressBar);
        this.parseAttributes(a);
    }

    public CustomizableProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CustomizableProgressBar, defStyleAttr, 0);
        this.parseAttributes(a);
    }

    public void setTextLeft(String text) {
        if (text == null || text != null && text.trim().length() == 0) {
            this.text_left.setVisibility(8);
            this.text_left.setText((CharSequence)"");
        } else {
            this.text_left.setVisibility(0);
            this.text_left.setText((CharSequence)text);
        }
    }

    public void setTextRight(String text) {
        if (text == null || text != null && text.trim().length() == 0) {
            this.text_right.setVisibility(8);
            this.text_right.setText((CharSequence)"");
        } else {
            this.text_right.setVisibility(0);
            this.text_right.setText((CharSequence)text);
        }
    }

    public void setIconLeftSrc(int resourceId) {
        try {
            this.getResources().getResourceName(resourceId);
        }
        catch (Resources.NotFoundException e) {
            return;
        }
        this.icon_left.setImageResource(resourceId);
        this.icon_left.setVisibility(0);
    }

    public void setIconRightSrc(int resourceId) {
        try {
            this.getResources().getResourceName(resourceId);
        }
        catch (Resources.NotFoundException e) {
            return;
        }
        this.icon_right.setImageResource(resourceId);
        this.icon_right.setVisibility(0);
    }

    public void setProgress(int progress) {
        this.progressBar.setProgress(progress);
        this.refreshRightText();
    }

    public void setMax(int max) {
        this.progressBar.setMax(max);
        this.refreshRightText();
    }

    public void setSecondaryProgress(int secondaryProgress) {
        this.progressBar.setSecondaryProgress(secondaryProgress);
    }

    public void setBackgroundColor(int color) {
        this.progressBar.setBackgroundColor(color);
    }

    public void setProgressColor(int color) {
        this.progressBar.setProgressColor(color);
    }

    public void setSecondaryProgressColor(int color) {
        this.progressBar.setSecondaryProgressColor(color);
    }

    public TextView getText_left() {
        return this.text_left;
    }

    public TextView getText_right() {
        return this.text_right;
    }

    private void init() {
        View view = CustomizableProgressBar.inflate((Context)this.getContext(), (int)R.layout.customizable_progress_bar, (ViewGroup)this);
        this.progressBar = (CustomProgressBar)view.findViewById(R.id.leo_progress_bar_progres_bar);
        this.text_left = (TextView)view.findViewById(R.id.leo_progress_bar_text_left);
        this.text_right = (TextView)view.findViewById(R.id.leo_progress_bar_text_right);
        this.icon_left = (ImageView)view.findViewById(R.id.leo_progress_bar_icon_left);
        this.icon_right = (ImageView)view.findViewById(R.id.leo_progress_bar_icon_right);
    }

    private void parseAttributes(TypedArray array) {
        this.progressBar.setProgressColor(array.getColor(R.styleable.CustomizableProgressBar_progressColor, 0));
        this.progressBar.setBackgroundColor(array.getColor(R.styleable.CustomizableProgressBar_backgroundColor, 0));
        this.progressBar.setSecondaryProgressColor(array.getColor(R.styleable.CustomizableProgressBar_secondaryProgressColor, 0));
        this.progressBar.setProgress(array.getInteger(R.styleable.CustomizableProgressBar_progress, 0));
        this.progressBar.setSecondaryProgress(array.getInteger(R.styleable.CustomizableProgressBar_secondaryProgress, 0));
        this.progressBar.setMax(array.getInteger(R.styleable.CustomizableProgressBar_max, 0));
        switch (array.getInt(R.styleable.CustomizableProgressBar_rounding, 0)) {
            case 0: {
                this.progressBar.setProgressDrawable(this.getResources().getDrawable(R.drawable.custom_progress_bar_horizontal_0));
                break;
            }
            case 5: {
                this.progressBar.setProgressDrawable(this.getResources().getDrawable(R.drawable.custom_progress_bar_horizontal_5dip));
                break;
            }
            case 10: {
                this.progressBar.setProgressDrawable(this.getResources().getDrawable(R.drawable.custom_progress_bar_horizontal_10dip));
                break;
            }
            case 25: {
                this.progressBar.setProgressDrawable(this.getResources().getDrawable(R.drawable.custom_progress_bar_horizontal_25dip));
                break;
            }
            case 50: {
                this.progressBar.setProgressDrawable(this.getResources().getDrawable(R.drawable.custom_progress_bar_horizontal_50dip));
            }
        }
        this.setTextLeft(array.getString(R.styleable.CustomizableProgressBar_text_left));
        this.setTextRight(array.getString(R.styleable.CustomizableProgressBar_text_right));
        this.setIconLeftSrc(array.getResourceId(R.styleable.CustomizableProgressBar_icon_left, -1));
        this.setIconRightSrc(array.getResourceId(R.styleable.CustomizableProgressBar_icon_right, -1));
        switch (array.getInt(R.styleable.CustomizableProgressBar_right_text_mode, 0)) {
            case 0: {
                this.rightTextMode = RightTextMode.CUSTOM;
                break;
            }
            case 1: {
                this.rightTextMode = RightTextMode.PROGRESS_PERCENTAGE;
                break;
            }
            case 2: {
                this.rightTextMode = RightTextMode.PROGRESS_VALUE;
                break;
            }
            case 3: {
                this.rightTextMode = RightTextMode.PROGRESS_VALUE_CURRENCY;
            }
        }
        this.refreshRightText();
        array.recycle();
    }

    private void refreshRightText() {
        switch (this.rightTextMode) {
            case PROGRESS_PERCENTAGE: {
                this.setTextRight(Integer.toString(this.progressBar.getProgress() * 100 / this.progressBar.getMax()) + " %");
                break;
            }
            case PROGRESS_VALUE: {
                this.setTextRight(Integer.toString(this.progressBar.getProgress()));
                break;
            }
            case PROGRESS_VALUE_CURRENCY: {
                this.setTextRight(NumberFormat.getCurrencyInstance(new Locale("PL", "pl")).format(this.progressBar.getProgress()));
            }
        }
    }

    private static enum RightTextMode {
        CUSTOM,
        PROGRESS_PERCENTAGE,
        PROGRESS_VALUE,
        PROGRESS_VALUE_CURRENCY;

    }
}

