/*
 * Decompiled with CFR 0.152.
 */
package pl.kro9bits.customizable_progress_bar;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.widget.ProgressBar;

class CustomProgressBar
extends ProgressBar {
    public CustomProgressBar(Context context) {
        super(context);
    }

    public CustomProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CustomProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setBackgroundColor(int color) {
        if (color == 0) {
            return;
        }
        this.setColor(color, 0);
    }

    public void setSecondaryProgressColor(int color) {
        if (color == 0) {
            return;
        }
        this.setColor(color, 1);
    }

    public void setProgressColor(int color) {
        if (color == 0) {
            return;
        }
        this.setColor(color, 2);
    }

    private void setColor(int color, int layerIndex) {
        if (this.getProgressDrawable() instanceof LayerDrawable) {
            LayerDrawable layered = (LayerDrawable)this.getProgressDrawable();
            Drawable circleDrawableExample = layered.getDrawable(layerIndex);
            circleDrawableExample.setColorFilter(color, PorterDuff.Mode.SRC_IN);
            this.setProgressDrawable((Drawable)layered);
        }
    }
}

