/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.RelativeLayout;
import androidx.annotation.Px;
import androidx.core.graphics.Insets;
import androidx.core.view.WindowInsetsCompat;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogXBaseBottomDialog;
import com.kongzue.dialogx.interfaces.NoTouchInterface;
import com.kongzue.dialogx.interfaces.OnSafeInsetsChangeListener;
import com.kongzue.dialogx.util.views.FitSystemBarUtils;
import java.lang.ref.WeakReference;

public class DialogXBaseRelativeLayout
extends RelativeLayout {
    public static boolean debugMode = false;
    private OnSafeInsetsChangeListener onSafeInsetsChangeListener;
    private WeakReference<BaseDialog> parentDialog;
    private boolean autoUnsafePlacePadding = true;
    private boolean focusable = true;
    private boolean interceptBack = true;
    private OnLifecycleCallBack onLifecycleCallBack;
    private PrivateBackPressedListener onBackPressedListener;
    private FitSystemBarUtils fitSystemBarUtils;
    private boolean isInited = false;
    boolean touch;
    float touchDownX;
    float touchDownY;
    private WeakReference<View> requestFocusView;
    protected Rect unsafePlace = new Rect();
    boolean isLightMode = true;
    float nowBkgAlphaValue;
    int[] extraPadding = new int[4];

    public FitSystemBarUtils getFitSystemBarUtils() {
        return this.fitSystemBarUtils;
    }

    public DialogXBaseRelativeLayout(Context context) {
        super(context);
        this.init(null);
    }

    public DialogXBaseRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public DialogXBaseRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 29) {
            this.setForceDarkAllowed(false);
        }
        if (!this.isInited) {
            if (attrs != null) {
                TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.DialogXBaseRelativeLayout);
                this.focusable = a.getBoolean(R.styleable.DialogXBaseRelativeLayout_baseFocusable, true);
                this.autoUnsafePlacePadding = a.getBoolean(R.styleable.DialogXBaseRelativeLayout_autoSafeArea, true);
                this.interceptBack = a.getBoolean(R.styleable.DialogXBaseRelativeLayout_interceptBack, true);
                a.recycle();
                this.isInited = true;
            }
            if (this.focusable) {
                this.setFocusable(true);
                this.setFocusableInTouchMode(true);
            }
            this.setBkgAlpha(0.0f);
            if (this.getParentDialog() != null && this.getParentDialog().getDialogImplMode() != DialogX.IMPL_MODE.VIEW) {
                this.setFitsSystemWindows(true);
            }
            this.setClipChildren(false);
            this.setClipToPadding(false);
            this.log("KONGZUE DEBUG DIALOGX: create fitSystemBarUtils");
            this.fitSystemBarUtils = FitSystemBarUtils.attachView((View)this, new FitSystemBarUtils.CallBack(){

                @Override
                public boolean isEnable(FitSystemBarUtils.Orientation orientation) {
                    return true;
                }

                @Override
                public void unsafeRect(int start, int top, int end, int bottom) {
                    DialogXBaseRelativeLayout.this.log("KONGZUE DEBUG DIALOGX: unsafeRect t=" + top + " b=" + bottom);
                    if (DialogXBaseRelativeLayout.this.unsafePlace == null) {
                        DialogXBaseRelativeLayout.this.unsafePlace = new Rect();
                    }
                    Insets systemBarInsets = null;
                    if (Build.VERSION.SDK_INT >= 23 && DialogXBaseRelativeLayout.this.getRootWindowInsets() != null) {
                        WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)DialogXBaseRelativeLayout.this.getRootWindowInsets());
                        boolean navigationBarsVisible = windowInsetsCompat.isVisible(WindowInsetsCompat.Type.navigationBars());
                        boolean imeVisible = windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime());
                        if (!imeVisible && navigationBarsVisible) {
                            systemBarInsets = windowInsetsCompat.getInsets(WindowInsetsCompat.Type.systemBars());
                            if (systemBarInsets.bottom == bottom && systemBarInsets.top == top && systemBarInsets.left == start && systemBarInsets.right == end) {
                                systemBarInsets = null;
                            }
                        }
                    }
                    if (systemBarInsets != null) {
                        DialogXBaseRelativeLayout.this.unsafePlace.left = Math.max(systemBarInsets.left, start);
                        DialogXBaseRelativeLayout.this.unsafePlace.top = Math.max(systemBarInsets.top, top);
                        DialogXBaseRelativeLayout.this.unsafePlace.right = Math.max(systemBarInsets.right, end);
                        DialogXBaseRelativeLayout.this.unsafePlace.bottom = Math.max(systemBarInsets.bottom, bottom);
                    } else {
                        DialogXBaseRelativeLayout.this.unsafePlace.left = start;
                        DialogXBaseRelativeLayout.this.unsafePlace.top = top;
                        DialogXBaseRelativeLayout.this.unsafePlace.right = end;
                        DialogXBaseRelativeLayout.this.unsafePlace.bottom = bottom;
                    }
                    if (DialogXBaseRelativeLayout.this.onSafeInsetsChangeListener != null) {
                        DialogXBaseRelativeLayout.this.onSafeInsetsChangeListener.onChange(DialogXBaseRelativeLayout.this.unsafePlace);
                    }
                    DialogXBaseRelativeLayout.this.setUnsafePadding(DialogXBaseRelativeLayout.this.unsafePlace.left, DialogXBaseRelativeLayout.this.unsafePlace.top, DialogXBaseRelativeLayout.this.unsafePlace.right, DialogXBaseRelativeLayout.this.unsafePlace.bottom);
                }

                @Override
                public int initialPadding(FitSystemBarUtils.Orientation orientation) {
                    switch (orientation) {
                        case Start: {
                            return DialogXBaseRelativeLayout.this.extraPadding[0];
                        }
                        case Top: {
                            return DialogXBaseRelativeLayout.this.extraPadding[1];
                        }
                        case End: {
                            return DialogXBaseRelativeLayout.this.extraPadding[2];
                        }
                        case Bottom: {
                            return DialogXBaseRelativeLayout.this.extraPadding[3];
                        }
                    }
                    return 0;
                }
            });
        }
    }

    public void setUnsafePadding(@Px int start, @Px int top, @Px int end, @Px int bottom) {
        this.log("KONGZUE DEBUG DIALOGX: setUnsafePadding=" + this.getParentDialog() + " t=" + top + " b=" + bottom);
        if (this.getParentDialog() instanceof DialogXBaseBottomDialog) {
            this.log("  KONGZUE DEBUG DIALOGX: isDialogXBaseBottomDialog");
            ViewGroup bkgView = (ViewGroup)this.findViewById(R.id.bkg);
            if (!((DialogXBaseBottomDialog)((Object)this.getParentDialog())).isBottomNonSafetyAreaBySelf() && bkgView != null) {
                this.log("    KONGZUE DEBUG DIALOGX: bkgView.setPadding b=" + bottom);
                bkgView.setPadding(0, 0, 0, bottom);
            }
            bottom = 0;
        }
        if (this.isAutoUnsafePlacePadding()) {
            this.log("  KONGZUE DEBUG DIALOGX: root.setPadding t=" + top + " b=" + bottom);
            this.setPadding(start, top, end, bottom);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        this.log("#dispatchKeyEvent: KeyCode=" + event.getKeyCode());
        if (this.isAttachedToWindow() && event.getAction() == 1 && event.getKeyCode() == 4 && this.interceptBack && this.onBackPressedListener != null) {
            return this.onBackPressedListener.onBackPressed();
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touch = true;
                this.touchDownX = event.getX();
                this.touchDownY = event.getY();
                break;
            }
            case 1: {
                if (!this.touch || this.findFocus() == this || this.getParentDialog() == null) break;
                float deltaTouchOffset = this.getParentDialog().dip2px(5.0f);
                if (!(Math.abs(event.getX() - this.touchDownX) <= deltaTouchOffset) || !(Math.abs(event.getY() - this.touchDownY) <= deltaTouchOffset)) break;
                this.callOnClick();
            }
        }
        if (this.getParentDialog() instanceof NoTouchInterface) {
            return super.onTouchEvent(event);
        }
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getWindowToken(), 2);
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            if (this.getParentDialog() == null || this.getParentDialog().getOwnActivity() == null) {
                return;
            }
            if (this.onLifecycleCallBack != null) {
                this.onLifecycleCallBack.onShow();
            }
            boolean bl = this.isLightMode = (this.getResources().getConfiguration().uiMode & 0x30) == 16;
            if (this.focusable) {
                this.requestFocus();
            }
        }
    }

    protected void onDetachedFromWindow() {
        if (this.onLifecycleCallBack != null) {
            this.onLifecycleCallBack.onDismiss();
        }
        this.onSafeInsetsChangeListener = null;
        super.onDetachedFromWindow();
    }

    public boolean performClick() {
        if (!this.isEnabled()) {
            return false;
        }
        return super.performClick();
    }

    public boolean callOnClick() {
        if (!this.isEnabled()) {
            return false;
        }
        return super.callOnClick();
    }

    public DialogXBaseRelativeLayout setOnLifecycleCallBack(OnLifecycleCallBack onLifecycleCallBack) {
        this.onLifecycleCallBack = onLifecycleCallBack;
        return this;
    }

    public float getSafeHeight() {
        return this.getMeasuredHeight() - this.unsafePlace.bottom - this.unsafePlace.top;
    }

    public void bindFocusView(View view) {
        if (view != this) {
            this.requestFocusView = new WeakReference<View>(view);
        }
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (this.getParentDialog() != null && this.getParentDialog() instanceof NoTouchInterface) {
            return false;
        }
        if (direction == 130 && this.requestFocusView != null && this.requestFocusView.get() != null && this.requestFocusView.get() != this) {
            return ((View)this.requestFocusView.get()).requestFocus();
        }
        View findFocusView = this.findFocus();
        if (findFocusView != null && findFocusView != this) {
            findFocusView.requestFocus();
            return true;
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    public void requestFocusOnResume() {
        View findFocusView = this.findFocus();
        if (findFocusView != null && findFocusView != this) {
            findFocusView.requestFocus();
            return;
        }
        this.requestFocus();
    }

    public DialogXBaseRelativeLayout setOnBackPressedListener(PrivateBackPressedListener onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        return this;
    }

    public OnSafeInsetsChangeListener getOnSafeInsetsChangeListener() {
        return this.onSafeInsetsChangeListener;
    }

    public DialogXBaseRelativeLayout setOnSafeInsetsChangeListener(OnSafeInsetsChangeListener onSafeInsetsChangeListener) {
        this.onSafeInsetsChangeListener = onSafeInsetsChangeListener;
        return this;
    }

    public boolean isAutoUnsafePlacePadding() {
        return this.autoUnsafePlacePadding;
    }

    public Rect getUnsafePlace() {
        return this.unsafePlace;
    }

    public DialogXBaseRelativeLayout setAutoUnsafePlacePadding(boolean autoUnsafePlacePadding) {
        this.autoUnsafePlacePadding = autoUnsafePlacePadding;
        return this;
    }

    public BaseDialog getParentDialog() {
        return this.parentDialog == null ? null : (BaseDialog)this.parentDialog.get();
    }

    public DialogXBaseRelativeLayout setParentDialog(BaseDialog parentDialog) {
        this.parentDialog = new WeakReference<BaseDialog>(parentDialog);
        if (parentDialog != null && parentDialog.getDialogImplMode() != DialogX.IMPL_MODE.VIEW) {
            this.setFitsSystemWindows(true);
        }
        if (this.unsafePlace != null) {
            this.log("KONGZUE DEBUG DIALOGX: setParentDialog()=" + this.getParentDialog());
            this.setUnsafePadding(this.unsafePlace.left, this.unsafePlace.top, this.unsafePlace.right, this.unsafePlace.bottom);
        } else {
            this.log("KONGZUE DEBUG DIALOGX: setParentDialog() unsafePlace is null");
        }
        return this;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        boolean newLightStatus;
        super.onConfigurationChanged(newConfig);
        boolean bl = newLightStatus = (newConfig.uiMode & 0x30) == 16;
        if (this.isLightMode != newLightStatus && DialogX.globalTheme == DialogX.THEME.AUTO && this.getParentDialog() != null) {
            this.getParentDialog().restartDialog();
        }
    }

    public DialogXBaseRelativeLayout setBkgAlpha(float alpha) {
        this.nowBkgAlphaValue = alpha;
        if (this.getBackground() != null) {
            this.getBackground().mutate().setAlpha((int)(alpha * 255.0f));
        }
        return this;
    }

    public void setBackground(Drawable background) {
        background.setAlpha((int)(this.nowBkgAlphaValue * 255.0f));
        super.setBackground(background);
    }

    public void setBackgroundColor(int color2) {
        this.setBackground((Drawable)new ColorDrawable(color2));
    }

    public boolean isBaseFocusable() {
        return this.focusable;
    }

    public boolean isInterceptBack() {
        return this.interceptBack;
    }

    public DialogXBaseRelativeLayout setInterceptBack(boolean interceptBack) {
        this.interceptBack = interceptBack;
        return this;
    }

    public void setVisibility(int visibility) {
        if (visibility == 8 && this.getAlpha() == 0.0f) {
            this.setAlpha(0.01f);
        }
        super.setVisibility(visibility);
    }

    public void setRootPadding(int left, int top, int right, int bottom) {
        this.extraPadding[0] = left;
        this.extraPadding[1] = top;
        this.extraPadding[2] = right;
        this.extraPadding[3] = bottom;
    }

    public int getRootPaddingLeft() {
        return this.extraPadding[0];
    }

    public int getRootPaddingTop() {
        return this.extraPadding[1];
    }

    public int getRootPaddingRight() {
        return this.extraPadding[2];
    }

    public int getRootPaddingBottom() {
        return this.extraPadding[3];
    }

    public int getUseAreaWidth() {
        return this.getWidth() - this.getRootPaddingRight();
    }

    public int getUseAreaHeight() {
        return this.getHeight() - this.getRootPaddingBottom();
    }

    protected void log(String s) {
        if (debugMode && DialogX.DEBUGMODE) {
            Log.e((String)">>>", (String)s);
        }
    }

    public static interface PrivateBackPressedListener {
        public boolean onBackPressed();
    }

    public static abstract class OnLifecycleCallBack {
        public void onShow() {
        }

        public abstract void onDismiss();
    }
}

